//var
var gulp = require('gulp');
//var browserify = require('gulp-browserify');
var rename = require('gulp-rename');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var cache = require('gulp-cache');
var remember = require('gulp-remember');
//var express = require('express');
var inject = require('gulp-inject');
//var imageop = require('gulp-image-optimization');
var uglifycss = require('gulp-uglifycss');
var templateCache = require('gulp-angular-templatecache');
var time = (new Date()).getTime();

var paths = {
    angular: ['angular/**/**/*.js'],
    templatecache: ['public/templates/**/*.html'],
    target: 'resources/views/base/base_admin.blade.php'
};


// var stylus = require('gulp-stylus').stylus;
// // var stylus = require('gulp-stylus');
// var sourcemaps = require('gulp-sourcemaps');

// // task compile css stylus
// gulp.task('one', function () {
//     return gulp.src('./public/design/tinku.styl')
//         .pipe(sourcemaps.init())
//         .pipe(stylus())
//         .pipe(sourcemaps.write('.', {
//             includeContent: false,
//             sourceRoot: '../../design/styl/'
//         }))
//         .pipe(gulp.dest('./build/css/'));
// });


gulp.task('js_new', function () {
    gulp.src(paths.angular)
        .pipe(concat('public/js/encoder.min.js'))
        .pipe(uglify())
        .pipe(gulp.dest('./'));
});

gulp.task('templatecache_new', function () {
    gulp.src(paths.templatecache)
        .pipe(templateCache({
            root: 'angular/views/',
            module: 'sys.templates',
            standalone: true
        }))
        .pipe(gulp.dest('angular'));

});

gulp.task('sys_js', function () {    
    gulp.watch(paths.angular, ['js_new']);  
});

gulp.task('sys_html', function () {    
    gulp.watch(paths.templatecache, ['templatecache_new']); 
});


//task concat js
gulp.task('js', function () {
    gulp.src(paths.angular)
        .pipe(concat('public/js/encoder.min.js'))
        .pipe(uglify())
        .pipe(gulp.dest('./'));

        // return cache.clearAll(); 
        // console.log("hereeee")
});

gulp.task('templatecache', function () {
    gulp.src(paths.templatecache)
        .pipe(templateCache({
            root: 'angular/views/',
            module: 'sys.templates',
            standalone: true
        }))
        .pipe(gulp.dest('angular'));

});

gulp.task('sys', function () {
    //cualquier cambio en esta carpeta o archivos ejecuta la tarea ['js']      
    gulp.watch(paths.angular, ['js']);  
    gulp.watch(paths.templatecache, ['templatecache']);
});

//region GULP OPTIONS


gulp.task('concat-css-vendor', function () {
    gulp.src([

        // 'public/js/vendor/angular-notify/angular-notify.css',
        'public/bower_components/daterange/daterangepicker-2.css',
        'public/bower_components/angucomplete-alt/angucomplete-alt.css',
    ])
        .pipe(concat('public/css/vendor.min.css'))
        .pipe(gulp.dest('./'));
});

gulp.task('concat-sys-vendor', function () {
    gulp.src([
        //stexo libraries ========
        // 'public/stexo/assets/js/jquery.min.js',
        'public/stexo/assets/js/bootstrap.bundle.min.js',
        'public/stexo/assets/js/metismenu.min.js',
        'public/stexo/assets/js/jquery.slimscroll.js',
        'public/stexo/assets/js/waves.min.js',
        'public/stexo/assets/js/app.js',
        // =================================

        'public/bower_components/angular/angular.min.js',
        'public/bower_components/underscore/underscore-min.js',
        'public/bower_components/angular-resource/angular-resource.min.js',
        'public/bower_components/angular-ui-router/release/angular-ui-router.min.js',
        'public/bower_components/angular-animate/angular-animate.min.js',
        'public/bower_components/sweetalert/sweetalert.min.js',
        'public/bower_components/ngSweetAlert/SweetAlert.min.js',
        'public/bower_components/angucomplete-alt/angucomplete-alt.js',

        'public/bower_components/daterange/moment.min.js',
        'public/bower_components/daterange/locale.js',
        'public/bower_components/daterange/daterangepicker.js',
        'public/bower_components/angular-growl-v2/build/angular-growl.min.js',


        'public/js/vendor/angular/angular-sanitize.js',
        'public/js/angular-panels/src/angular.panels.js',
        // 'public/bower_components/angular-bootstrap/ui-bootstrap.min.js',
        // 'public/bower_components/angular-bootstrap/ui-bootstrap-tpls.min.js',
        'public/js/jquery-timepicker/jquery.timepicker.js',
        'public/js/textAngular.min.js',

        'public/js/dirPagination.js',
        'public/js/parsley/parsley.min.js',
        // 'public/js/angular-bootstrap/ui-bootstrap-tpls.js',
        'public/js/alasql/alasql.min.js',
        'public/js/alasql/xlsx.core.min.js',
        //'app/assets/main.js'


        // 'public/js/vendor/angular-notify/angular-notify.js',
        'public/js/ui-bootstrap-tpls-3.0.6.js',

        'public/stexo/plugins/sweet-alert2/sweetalert2.min.js',
        'public/stexo/plugins/morris/morris.min.js',
        // 'public/stexo/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js'

    ])
        .pipe(concat('public/js/vendor.min.js'))
        //.pipe(rename('public/js/yourchef.min.js'))
        //.pipe(uglify())
        .pipe(gulp.dest('./'));
});
//endregion

//functions
var getVersion = function () {
    return fs.readFileSync('Version');
};

// Get copyright using NodeJs file system
var getCopyright = function () {
    return fs.readFileSync('Copyright');
};

gulp.task('copy:dist', ['sys']);

gulp.task('inject:dist', ['copy:dist'], function () {
    console.log("hereee");
    var target = gulp.src(paths.target),
        jsfile = 'public/js/encoder.min.js',
        // libjsfile = `${__dirname}/build/library.js`,
        filesources = [jsfile];

    return target.pipe(inject(gulp.src(filesources, {read: false}), {
        addRootSlash: true,
        transform: function (filePath, file, i, length) {
            var newPath = filePath.replace('encoder/', '');
            arguments[0] = newPath + '?v=' + time;
            return inject.transform.apply(inject.transform, arguments);
        }
    }))
        // .pipe(gulp.dest('./encoder/templates/admin'));
        .pipe(gulp.dest('./resources/views/base'));
});