(function () {
    'use strict';
    angular.module('sys.api')
        .factory('permissions', permissions)
        .directive('hasPermission', hasPermission);

    hasPermission.$inject = ['permissions'];
    permissions.$inject = ['$rootScope'];

    function hasPermission(permissions) {
        return {
            link: function (scope, element, attrs) {
                if (!_.isString(attrs.hasPermission)) {
                    throw 'hasPermission value must be a string'
                }
                var value = attrs.hasPermission.trim();
                var notPermissionFlag = value[0] === '!'
                if (notPermissionFlag) {
                    value = value.slice(1).trim()
                }

                function toggleVisibilityBasedOnPermission() {
                    var hasPermission = permissions.hasPermission(value);
                    var get_permission = permissions.getPermissionAction(value);

                    if ((hasPermission && !notPermissionFlag) || (!hasPermission && notPermissionFlag)) {

                        if (get_permission.is_show){
                            element[0].style.visibility = 'visible';
                        }
                        else{
                            if (get_permission.action === 'hidden') {
                                element[0].style.visibility = 'hidden';
                            } else {
                                console.log("assigned disabled")
                                element[0].disabled = true;
                            }
                        }
                    } else {
                        element[0].style.visibility = 'hidden';
                    }
                }
                toggleVisibilityBasedOnPermission()
                scope.$on('permissionsChanged', toggleVisibilityBasedOnPermission)
            },
        }
    }

    function permissions($rootScope) {
        var permissionList
        return {
            setPermissions: function (permissions) {
                permissionList = permissions;
                $rootScope.$broadcast('permissionsChanged');
            },
            hasPermission: function (permission) {
                permission = permission.trim();
                return permissionList.some((item) => {
                    // if (typeof item.Name !== 'string') {
                    if (typeof item.code !== 'string') {
                        // item.Name is only used because when I called setPermission, I had a Name property
                        return false
                    }
                    // return item.Name.trim() === permission
                    return item.code.trim() === permission;
                })
            },

            getPermissionAction: function (permission) {
                permission = permission.trim();
                var action_code;
                for (var i = 0; i < permissionList.length; i++) {
                    if (permissionList[i].code === permission) {
                        action_code = permissionList[i];
                        break;
                    }
                }
                return action_code;
            },
        }
    }

})();


