(function () {
    'use strict';

    angular.module('sys.api')
        .constant('REGEX', {
            'DNI_OR_RUC': /^[0-9](?:.{7}|.{10})$/,
            'RUC': /^[0-9]{11}$/,
            'EMAIL': /^[a-zA-Z0-9.!#$%&\'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/i,
            'EMAIL1': /^([a-z]+[a-z1-9._-]*)@{1}([a-z1-9\.]{2,})\.([a-z]{2,3})$/,
            'EMAIL-LONGITUD': /^.+@.+\.[a-z]{2,4}$/i,
            'URL': /^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \?=.-]*)*\/?$/,
            'PHONE-FIJO': /^(8|9)[0-9]{8}$/,
            'CELLPHONE': /^(6|7)[0-9]{8}$/,
            'SOLO-LETRAS': /^[a-zA-ZñÑ]+$/,
            'SOLO-NUMBER_REQUIRED': /^[0-9]+$/,
            'SOLO-NUMBER': /^\d*$/
        })
        .constant("CLIENT", {
            "TYPE": [
                {description: "Natural", id: 2},
                {description: "Jurídico", id: 1}
            ],
            "SEX": [
                {description: "Seleccione", id: null},
                {description: "Masculino", id: 'M'},
                {description: "Femenino", id: 'F'},
                {description: "Otros", id: 'O'}
            ],
            "STATUS": [
                {description: "Seleccione", id: null},
                {description: "Soltero", id: 1},
                {description: "Casado", id: 2},
                {description: "Otros", id: 3}
            ],
            "AGE_GROUP": [
                // {description: "Seleccione", id: null},
                {description: "Adulto", id: 'A'},
                {description: "Niño", id: 'N'},
                {description: "Infante", id: 'I'}
            ],
            "DEFAULT": 1
        })
        .constant("TOURISM", {
            "CATEGORY_HOTEL": [
                {description: "Sin asignar", id: null},
                {description: "1 estrella", id: 1},
                {description: "2 estrellas", id: 2},
                {description: "3 estrellas", id: 3},
                {description: "4 estrellas", id: 4},
                {description: "5 estrellas", id: 5}
            ],
            "ORIGIN_BOOKIN": [
                {description: "Oficina", id: 1},
                {description: "Colaboradores", id: 2},
                {description: "Facebook", id: 3},
                {description: "Whatsapp", id: 4},
                {description: "Instagram", id: 5},
                {description: "Página web", id: 6},
            ],

            "ARRIVAL_PLACES": [
                {description: "Sin asignar", id: null},
                {description: "Aeropuerto", id: 1},
                {description: "Terminal terrestre", id: 2},
                {description: "Otros", id: 3},
            ],
            "VEHICLE_TOURS": [
                {description: "Compartido", class: "info",id: 1},
                {description: "Privado", class: "orange", id: 2},
            ],
            "SHIFT_TOURS": [
                {description: "Full day", id: 1},
                {description: "Mañana", id: 2},
                {description: "Tarde", id: 3},
                {description: "Noche", id: 4},
            ],
            "TYPE_FLIGHT": [
                {description: "Ida", id: 1},
                {description: "Vuelta", id: 2},
            ],
            "TIME_ARRIVAL_DEFAULT": "08:00",
        })
        .constant("NUMBER", {
            ZERO: 0,
            ONE: 1
        })
        .constant("VOUCHER", {
            SIN_DOCUMENTO:0,
            BOLETA: 1,
            FACTURA: 2,
            NOTA_CREDITO:3,
            NOTA_DEBITO:4,
            RECIBO_INGRESO:9,
            RECIBO_EGRESO:10,
            NOTA_PEDIDO:8
        })
        .constant("TYPE_DOCUMENT_SUNAT_IDS", {
            BOLETA: "03",
            FACTURA: "01"
        })
        .constant("EXTEND_CLIENT", {
            NATIONALITY: 168,
            ORIGIN: 0,
            ISO : 'PE'
        })
        .constant("KEY", {
        ENTER: 13
    })
        .constant("DASHBOARDS", {
        SALES: {
            TODAY_YESTERDAY: 'today-yesterday',
            THIS_LAST_WEEK: 'this-last-week',
            THIS_YEAR: 'this-year',
            CUSTOM: 0
        }
    })
        .constant("LOCALE_D3", {
            es_ES: {
                "decimal": ".",
                "thousands": ",",
                "grouping": [3],
                "currency": ["S/", ""],
                "dateTime": "%a %b %e %X %Y",
                "date": "%d/%m/%Y",
                "time": "%H:%M:%S",
                "periods": ["AM", "PM"],
                "days": ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"],
                "shortDays": ["Dom", "Lun", "Mar", "Mi", "Jue", "Vie", "Sab"],
                "months": ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
                "shortMonths": ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"]
            }
        })
        .constant("PAYMENT_METHOD", {
            "cash": {description: 'Efectivo', id: 1},
            "visa": {description: 'Visa', id: 2},
            "check": {description: 'Cheque', id: 3},
            "deposit": {description: 'Deposito a cuenta', id: 4},
            "quota": {description: 'Pago a cuotas', id: 5}
        })

        .constant("TYPE_DOCUMENT", {
            "DNI": {max_length: 8, id: 1},
            "RUC": {max_length: 11, id: 2}
        })
        .constant("TYPE_DOCUMENT_ID", {
            "DNI": "1",
            "RUC": "6",
            "Pasaporte": "7",
            "Carnet de extranjeria": "4",
            "Celula diplomatica de identidad": "A",
            "NO_DOMICILED": "0"
        }).constant("SEARCH", {
                MIN: 1,
                MIN_LETTERS: 3,
                TYPE_SEARCH: [
                    {'id': 1, 'label': 'Buscador', 'icon': 'fa-search', 'selected': true, 'class': 'border-right' },
                    {'id': 2, 'label': 'Código de barras', 'icon': 'fa-barcode', 'selected': false, 'class': ''}
                ]
            })
        .constant("ORDER", {
            "SHIFT": [
                {description: "Seleccione turno", id: 0},
                {description: "Mañana", id: 1},
                {description: "Tarde", id: 2}
            ],
            "STATUS": [
                {description: "Pendiente", id: false},
                {description: "Entregado", id: true}
            ]
        })

        .constant("PRODUCT", {
            "TYPEPRICE": [
                {description: "Precio general", id: 1},
                {description: "Precio por unidad de medida", id: 2},
                {description: "Precio por variantes", id: 3},
                {description: "Precio variable", id: 4}
            ],
            "TYPEPRODUCT": [
                {description: "BIENES", id: 1},
                {description: "SERVICIOS", id: 2},
                // {description: "Contratos", id: 3}
            ],
        })
        .constant("EXPORT", {
            "FORMAT": [
                {description: "PDF", id: 1},
                {description: "EXCEL", id: 2}
            ],
            "STATUS_VOUCHER": [
                {description: "TODOS", id: null},
                {description: "CONCRETADO", id: 1},
                {description: "ANULADO", id: 2}
            ],
            "SUNAT_ENVIO": [
                {description: "TODOS", id: null},
                {description: "ENVIADO", id: 1},
                {description: "PENDIENTES", id: 2}
            ],
        })

        .constant("TRANSACTION", {
            "TYPES": [
                {description: "CONTADO", id: 1},
                {description: "CRÉDITO", id: 2}
            ],
            "INTERVALS": [
                {description: "DIARIO", id: 1},
                {description: "SEMANAL", id: 7},
                {description: "QUINCENAL", id: 15},
                {description: "MENSUAL", id: 30},
                {description: "ANUAL", id: 365},
            ],
            "VIRTUAL_CHANNELS": [
                {description: "Seleccione canal", id: 0},
                {description: "Whatsapp", id: 1},
                {description: "Facebook", id: 2},
                {description: "Instagram", id: 3},
                {description: "Página Web", id: 4},
                {description: "App Móvil", id: 5},
                {description: "Correo electrónico", id: 6}
            ],
            "ORIGIN_SALE": [
                {description: "Venta en local", id: 1},
                {description: "Venta virtual", id: 2}
            ],
        })
        .constant("SETTING", {
            "PRINT": [
                {description: "A4", id: 'a4'},
                {description: "A5(media página)", id: 'a5'},
                {description: "Ticket", id: 'ticket'},
            ],
        })

        .constant("USER", {
            "STATUS": [
                {description: "Activos", id: true},
                {description: "De baja", id: false}
            ],
            "POSITION": [
                {description: "Clientes", id: 1},
                {description: "Proveedores", id: 2},
                {description: "Empleados", id: 3}
            ]
        })

        .constant("REPORT", {
            "LIMIT": [
                {description: "5", id: 5},
                {description: "10", id: 10},
                {description: "25", id: 25},
                {description: "50", id: 50}
            ]
        })
    ;
})();

