(function () {
    'use strict';
    angular.module('sys.api')
        .factory('RESTService', RESTService);

    RESTService.$inject = ['ApiService', 'AlertFactory', '_', '$http', 'loadingAlert'];

    function RESTService(ApiService, AlertFactory, _, $http, loadingAlert) {
        var module = "rest";
        var url_api = '/api/';

        var rest = {
            all: all,
            get: get,
            updated: updated,
            deleted: deleted,
            save: save,
            find: find
        };

        return rest;

        function all(model, action, callback, callbackConfirmError) {

            loadingAlert.show();

            var Model = ApiService.instance(module, model);
            var query = Model.query({action: action});
            query.$promise.then(function (response) {
                if (typeof callback === "function") {
                    loadingAlert.hide();
                    callback(response);
                }
            }).catch(function (error) {
                loadingAlert.hide()
                AlertFactory.showErrors(
                    {
                        title: "hubo un error",
                        message: error.data.message
                    }, function (isConfirm) {
                        if (typeof callbackConfirmError === "function") {
                            callbackConfirmError(isConfirm);
                        }
                    }
                );
                if (typeof callbackConfirmError === "function") {
                    callbackConfirmError(error);
                }
            });
        }

        function get(model, id, callback, action, confirmCallbackError, cancelCallbackError) {
            loadingAlert.show();
            $http({
                method: 'GET',
                url: url_api + model +'/'+id,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    // 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).success(function (response) {
                if (typeof callback === "function") {
                    loadingAlert.hide();
                    callback(response);
                }
            }).error(function (error) {
                loadingAlert.hide();

                if(!_.isUndefined(error.code)){
                    if(error.code == 100){
                        AlertFactory.showWarning(
                            {
                                title: "Advertencia",
                                message: error.message
                            },
                            function (isConfirm) {
                                if (typeof callbackConfirmError === "function") {
                                    callbackConfirmError(isConfirm);
                                }
                            }
                        );
                    }else{
                        AlertFactory.showErrors(
                            {
                                title: "hubo un error",
                                message: error.message
                            },
                            function (isConfirm) {
                                if (typeof callbackConfirmError === "function") {
                                    callbackConfirmError(isConfirm);
                                }
                            }
                        );
                    }
                }
                else{
                    AlertFactory.showErrors(
                        {
                            title: "hubo un error",
                            message: error
                        },
                        function (isConfirm) {
                            if (typeof callbackConfirmError === "function") {
                                callbackConfirmError(isConfirm);
                            }
                        }
                    );
                }

                if (typeof callbackConfirmError === "function") {
                    callbackConfirmError(error);
                }
            });
        }

        function updated(model, $id, $attributes, callback, callbackConfirmError) {
            loadingAlert.show();
            $http({
                method: 'PUT',
                url: url_api + model +'/'+$id,
                data:$.param($attributes),
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).success(function (response) {
                if (typeof callback === "function") {
                    loadingAlert.hide();
                    callback(response);
                }
            }).error(function (error) {
                loadingAlert.hide();

                if(!_.isUndefined(error.code)){
                    if(error.code == 100){
                        AlertFactory.showWarning(
                            {
                                title: "Advertencia",
                                message: error.message
                            },
                            function (isConfirm) {
                                if (typeof callbackConfirmError === "function") {
                                    callbackConfirmError(isConfirm);
                                }
                            }
                        );
                    }else{
                        AlertFactory.showErrors(
                            {
                                title: "hubo un error",
                                message: error.message
                            },
                            function (isConfirm) {
                                if (typeof callbackConfirmError === "function") {
                                    callbackConfirmError(isConfirm);
                                }
                            }
                        );
                    }
                }
                else{
                    AlertFactory.showErrors(
                        {
                            title: "hubo un error",
                            message: error
                        },
                        function (isConfirm) {
                            if (typeof callbackConfirmError === "function") {
                                callbackConfirmError(isConfirm);
                            }
                        }
                    );
                }

                if (typeof callbackConfirmError === "function") {
                    callbackConfirmError(error);
                }
            });

            // var Model = ApiService.instance(module, model);
            // Model.update({id: $id}, $attributes).$promise.then(function (response) {
            //     if (typeof callback === "function") {
            //         callback(response);
            //     }
            // }).catch(function (error) {
            //     AlertFactory.showErrors(
            //         {
            //             title: "hubo un error",
            //             message: error.data.message
            //         }, function (isConfirm) {
            //             if (typeof callbackConfirmError === "function") {
            //                 callbackConfirmError(isConfirm);
            //             }
            //         }
            //     );
            //
            //     if (typeof callbackConfirmError === "function") {
            //         callbackConfirmError(error);
            //     }
            //
            // });
        }

        function deleted(model, $id, callback, callbackConfirmError) {

            loadingAlert.show();
            $http({
                method: 'DELETE',
                url: url_api + model +'/'+$id,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).success(function (response) {
                if (typeof callback === "function") {
                    loadingAlert.hide();
                    callback(response);
                }
            }).error(function (error) {
                loadingAlert.hide();
                AlertFactory.showErrors(
                    {
                        title: "hubo un error",
                        message: error
                    },
                    function (isConfirm) {
                        if (typeof callbackConfirmError === "function") {
                            callbackConfirmError(isConfirm);
                        }
                    }
                );

                if (typeof callbackConfirmError === "function") {
                    callbackConfirmError(error);
                }
            });

            // var Model = ApiService.instance(module, model);
            // Model.delete({id: $id}).$promise.then(function (response) {
            //     if (typeof callback === "function") {
            //         callback(response);
            //     }
            // }).catch(function (error) {
            //     AlertFactory.showErrors(
            //         {
            //             title: "hubo un error",
            //             message: error.data.message
            //         }, function (isConfirm) {
            //             if (typeof callbackConfirmError === "function") {
            //                 callbackConfirmError(isConfirm);
            //             }
            //         }
            //     );
            //
            //     if (typeof callbackConfirmError === "function") {
            //         callbackConfirmError(error);
            //     }
            // });
        }

        function save(model, $attributes, callback, callbackConfirmError) {
            loadingAlert.show();
            $http({
                method: 'POST',
                url: url_api + model,
                data: $.param($attributes),
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).success(function (response) {
                if (typeof callback === "function") {
                    loadingAlert.hide();
                    callback(response);
                }
            }).error(function (error) {
                loadingAlert.hide();

                if(!_.isUndefined(error.code)){

                    if(error.code == 100){
                        AlertFactory.showWarning(
                            {
                                title: "Advertencia",
                                message: error.message
                            },
                            function (isConfirm) {
                                if (typeof callbackConfirmError === "function") {
                                    callbackConfirmError(isConfirm);
                                }
                            }
                        );
                    }else{
                        AlertFactory.showErrors(
                            {
                                title: "hubo un error",
                                message: error.message
                            },
                            function (isConfirm) {
                                if (typeof callbackConfirmError === "function") {
                                    callbackConfirmError(isConfirm);
                                }
                            }
                        );
                    }
                }
                else{
                    AlertFactory.showErrors(
                        {
                            title: "hubo un error",
                            message: error
                        },
                        function (isConfirm) {
                            if (typeof callbackConfirmError === "function") {
                                callbackConfirmError(isConfirm);
                            }
                        }
                    );
                }

                if (typeof callbackConfirmError === "function") {
                    callbackConfirmError(error);
                }
            });

            // var Model = ApiService.instance(module, model);
            //
            // Model.save($attributes).$promise.then(function (response) {
            //     if (typeof callback === "function") {
            //         callback(response);
            //     }
            // }).catch(function (error) {
            //     AlertFactory.showErrors(
            //         {
            //             title: "hubo un error",
            //             message: error.data.message
            //         },
            //         function (isConfirm) {
            //             if (typeof callbackConfirmError === "function") {
            //                 callbackConfirmError(isConfirm);
            //             }
            //         }
            //     );
            //
            //      if (typeof callbackConfirmError === "function") {
            //         callbackConfirmError(error);
            //      }
            //
            // });
        }

        function find(model, id, callback, action, callbackConfirmError) {
            var Model = ApiService.instance(module, model);
            var query = Model.query({id: id}, {action: action});
            query.$promise.then(function (response) {
                if (typeof callback === "function") {
                    callback(response);
                }
            }).catch(function (error) {
                AlertFactory.showErrors(
                    {
                        title: "Hubo un error",
                        message: error.data.message
                    }, function (isConfirm) {
                        if (typeof callbackConfirmError === "function") {
                            callbackConfirmError(isConfirm);
                        }
                    }
                );

                if (typeof callbackConfirmError === "function") {
                    callbackConfirmError(error);
                }

            });
        }



    }

})();
