(function () {
    'use strict';

    angular.module('sys', [
        //dependencies
        "ngSanitize",
        'ngAnimate',
        'ui.router',
        'ui.bootstrap',
        'sys.utils.libraries',
        'sys.templates',
        'sys.utils.services',
        'sys.utils.utils',
        'angucomplete-alt',
        'dirPagination',
        'sys.utils.widgets',
        'sys.utils.filters',
        'sys.api',
        'sys.app.system',
        "textAngular"

    ]).run(Run)
        .controller('OverloadCtrl', OverloadCtrl)
        .controller('DashboardCtrl', DashboardCtrl)
        .controller('MyAccountCtrl', MyAccountCtrl)
        .config(Config);

    Config.$inject = [
        '$interpolateProvider',
        '$httpProvider',
        '$stateProvider',
        '$urlRouterProvider',
        '$resourceProvider'
    ];

    OverloadCtrl.$inject = ['$scope'];
    DashboardCtrl.$inject = ['$scope', 'RESTService', '$timeout', '$state'];
    MyAccountCtrl.$inject = ['$scope', '$uibModal', 'RESTService'];

    Run.$inject = ['$rootScope', '$state', '$window', 'RESTService','_', '$timeout', 'permissions'];

    function Run($rootScope, $state, $window, RESTService, _, $timeout, permissions) {

        // $rootScope.branch_url

         //region verify internet
        $rootScope.online = navigator.onLine;

        $window.addEventListener("offline", function () {
            $rootScope.$apply(function () {
                $rootScope.online = false;
            });
        }, false);

        $window.addEventListener("online", function () {
            $rootScope.$apply(function () {
                $rootScope.online = true;
            });
        }, false);


        RESTService.all('config', null, function (response) {
            $rootScope.modules = response.modules;
            permissions.setPermissions(response.permissions);

            // $rootScope.permissions = response.permission;
            // $rootScope.set_modules = response.set_modules;
            // $rootScope.profile = response.profile;
            // $rootScope.design_box_product = response.design_box_product;
            // $rootScope.modules_plan = response.children_modules;//modulos hijos
            //
            // console.log($rootScope.permissions);
            //
            // defered.resolve(response.set_modules);
        });

        $rootScope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
            var stateUrl = toState.module;
            var nameState = toState.name;

            $rootScope.title_page = toState.title;

            activeMenuLeft(nameState, stateUrl);

            // console.log(stateUrl);
            // console.log(nameState);

            checkBoxMoney(stateUrl);

            if(_.isUndefined($rootScope.modules)){
                $timeout(function () {
                    veryfiedModules(stateUrl);
                }, 1000);
            }
            else {
                $timeout(function () {
                    veryfiedModules(stateUrl);
                }, 200);
            }

            var w_screen_mobile = 449;

            var now_width = $(window).width();

            if(now_width <= w_screen_mobile){
                $("body").addClass("enlarged");
            }
        });

        function checkBoxMoney(module) {
            RESTService.all('money/checkbox', null, function (response) {

                var check_modules = ["sale", "incomes", "expenses"];

                $.each(check_modules, function (i, item) {
                    if(item==module){
                        if(response.code == false){
                            swal({
                                title: "IMPORTANTE!",
                                html: ''+response.message+'',
                                type: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#30419b",
                                cancelButtonClass: 'btn btn-secondary ml-2',
                                confirmButtonText: 'Ir al módulo de caja <i class="fas fa-money-bill-alt m-r-5"></i>',
                                cancelButtonText: "Cerrar",
                            }).then(function (isConfirm) {
                                if (isConfirm.value == true) {
                                    $state.transitionTo('money.opening', null, {'reload': true});
                                }
                            });
                        };
                    }
                });
            });
        }


        function activeMenuLeft(nameState, stateUrl) {
            var arrName = nameState.split('.');

            $(".metismenu").find(".mm-active").removeClass("mm-active");
            $(".parent_"+arrName[0]).removeAttr('style');
            $(".metismenu").find(".mm-show").removeClass("mm-show");

            $("#"+arrName[0]).addClass('mm-active');
            $("."+arrName[0]).addClass('mm-active');
            $(".parent_"+arrName[0]).addClass('mm-show');

            $("#"+stateUrl).addClass('mm-active');
        }


        function veryfiedModules(stateUrl) {
            var modules = $rootScope.modules;
            var check_ = false;
            var valid_child = false;

            for (var i = 0; i < modules.length; i++) {
                if(modules[i].isParent){
                    var childs = modules[i].childs;

                    for (var j = 0; j < childs.length; j++) {
                        if (stateUrl === childs[j].module) {
                            check_ = true;
                            valid_child = true;
                            break;
                        }
                    }
                }
                else{
                    if (stateUrl === modules[i].module) {
                        check_ = true;
                        break;
                    }
                }

                if (valid_child){
                    check_ = true;
                    break;
                }
            }

            // for (var i in modules) {
            //     if(stateUrl===modules[i].module){
            //         check_ = true;
            //         break;
            //     }
            // }

            if(!check_){
                swal("Cuidado!", "No tiene los permisos suficientes para acceder a esta vista!", "warning");
                $state.transitionTo('dashboard', null, {'reload': true});
            }
        }

        //endregion
    }

    function Config($interpolateProvider, $httpProvider,
                    $stateProvider, $urlRouterProvider, $resourceProvider) {
        // The alternative is using {{ verbatim }}
        $interpolateProvider.startSymbol('[[').endSymbol(']]');

        // CSRF Support
        $httpProvider.defaults.xsrfCookieName = 'csrftoken';
        $httpProvider.defaults.xsrfHeaderName = 'X-CSRFToken';

        $resourceProvider.defaults.stripTrailingSlashes = false;

        //add loading
        $httpProvider.interceptors.push(['$q', '$rootScope', function ($q, $rootScope) {
            var numLoadings = 0;
            return {
                'request': function (config) {
                    // intercepts the request
                    numLoadings++;

                    // Show loader
                    $rootScope.$broadcast("loader_show");

                    return config;
                },
                'requestError': function (rejection) {
                    if (!(--numLoadings)) {
                        // Hide loader
                        $rootScope.$broadcast("loader_hide");
                    }
                    return $q.reject(rejection);
                },
                'response': function (response) {
                    if ((--numLoadings) === 0) {
                        // Hide loader
                        $rootScope.$broadcast("loader_hide");
                    }
                    return response;
                    // intercepts the response. you can examine things like status codes
                },
                'responseError': function (rejection) {
                    if (!(--numLoadings)) {
                        // Hide loader
                        $rootScope.$broadcast("loader_hide");
                    }
                    // intercepts the response when the response was an error
                    return $q.reject(rejection);
                }
            }

        }]);


        $stateProvider
            .state('dashboard', {
                url: '/',
                templateUrl: '../templates/dashboard/dashboard.html',
                controller: 'DashboardCtrl',
                module:"dashboard",
                title:"Dashboard",
            });

        $urlRouterProvider.otherwise('/');

    }

    function OverloadCtrl($scope) {
        $scope.$on("loader_show", function () {
            $scope.show_loading = true;
        });

        $scope.$on("loader_hide", function () {
            $scope.show_loading = false;
        });
    }

    function DashboardCtrl($scope, RESTService, $timeout, $state) {

        init();

        function init() {
            RESTService.all('dashboard', null, function (response) {
                $scope.count_product = response.count_product;
                $scope.count_client = response.count_client;
                $scope.count_provider= response.count_provider;
                $scope.total_sale_month= response.total_sale_month;
                $scope.list_credits= response.list_credits;
                $scope.total_credit= response.total_credit;


                generate(response.graph_sale_month);

                // console.log(response.graph_sale_month)
            });
        };

        $scope.goToListCharge = function () {
            $state.transitionTo('money.charges', {entity: null}, {'reload': true});
        }

        function generate(summary_data){

            var obj_months = [
                {number_month: 1,name: "Ene",value:0},
                {number_month: 2,name: "Feb",value:0},
                {number_month: 3,name: "Mar",value:0},
                {number_month: 4,name: "Abr",value:0},
                {number_month: 5,name: "May",value:0},
                {number_month: 6,name: "Jun",value:0},
                {number_month: 7,name: "Jul",value:0},
                {number_month: 8,name: "Agos",value:0},
                {number_month: 9,name: "Set",value:0},
                {number_month: 10,name: "Oct",value:0},
                {number_month: 11,name: "Nov",value:0},
                {number_month: 12,name: "Dec",value:0},
            ];

            var categories = [];
            var series = [];

            $.each(summary_data, function (i, item) {
                obj_months.map(function(obj, index){
                    if(obj.number_month == item.number_month){
                        obj_months[index].value = parseFloat(item.total_month);
                    }
                });
            });


            $.each(obj_months, function (i, item) {
                categories.push(item.name);
                series.push(item.value);
            });


            Highcharts.chart('container', {

                title: {
                    text: 'Gráfico de ventas mensuales año '
                },

                xAxis: {
                    categories: categories
                },
                yAxis: {
                    title: {
                        text: 'Total S/.'
                    },
                    labels: {
                        formatter: function () {
                            return this.value;
                        }
                    }
                },

                series: [
                    {
                        name: 'Total S/',
                        marker: {
                            symbol: 'square'
                        },
                        data: series,
                        showInLegend: false

                    }
                ]
            });
        }

    };

    function MyAccountCtrl($scope, $uibModal, RESTService) {

        $scope.checkMyAccount = function (user_id) {
            RESTService.get('user/edit', user_id, function (response) {
                // var obj = {'id': 0};
                var obj = {
                    'id': user_id,
                    'data': response.data
                };

                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/utils/myaccountview.html',
                    controller: 'MyAccountViewCtrl',
                    size: 'sm',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                }).result.then(function (result) {
                });
            });

        }
    }

})();


