(function () {
    'use strict';
    angular.module('sys.app.creditnotes')
        .controller('BillingCreditNoteCtrl', BillingCreditNoteCtrl);

    BillingCreditNoteCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal', 'EXPORT'];


    function BillingCreditNoteCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal, EXPORT) {

        $scope.entity = {};
        $scope.text = null;
        $scope.currentPage = 1;
        var object = "";

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        $scope.envioSelected = {id: null, description:'TODOS', value:null};

        init();

        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage +'&sunat_envio='+$scope.envioSelected.id+
                "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
            RESTService.all('billing/notedocuments', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        function sync() {
            RESTService.all('config/typevoucher/sale', null, function (response) {
                var last = response.results.length;
                $scope.typevouchers = response.results;
                response.results[last] = {id: null, description: 'TODOS', value: null};
                $scope.typeVoucherSelected = response.results[last];
            });


            $scope.sunatenvios = EXPORT.SUNAT_ENVIO;
            $scope.envioSelected = EXPORT.SUNAT_ENVIO[0];

            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                        init();
                    }
                );
            }, 50);

        };

        $scope.new = function () {
            var source = {'purchase': {'id':0 }};

            $state.transitionTo('billing.creditnotes.new', {entity: source}, {
                'reload': 'billing.creditnotes.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.printVoucher = function (item) {
            window.open('/print/note/document/'+ item.id)
        }

        $scope.downloadXml = function (item) {
            RESTService.all('company/url_download_xml', null, function (response) {
                window.open(response.url_download + item.billing_external_id);
            });
        };
    }

})();


