(function () {
    'use strict';
    angular.module('sys.utils.utils')
        .controller('ModalCreditNoteCtrl', ModalCreditNoteCtrl);

    ModalCreditNoteCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout', 'VOUCHER', 'AlertFactory'];

    function ModalCreditNoteCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, VOUCHER, AlertFactory) {

        $scope.data = PARAM.data;
        $scope.billing = PARAM.billing;

        var val_date_issue =  moment().format('YYYY-MM-DD');

        $scope.note = {
            'nro_voucher': null,
            'date_document': val_date_issue,
            'exchange_currency': null,
            'affect_moneybox': true,
            'motive': null,
        };

        init();


        function init() {

            RESTService.all('config/typevoucher/notes', null, function (response) {
                $scope.typevouchers = response.results;
                $scope.typeVoucherSelected = response.results[0];
                getSerieVoucher($scope.typeVoucherSelected.id);
                getBillingCodes($scope.typeVoucherSelected.id);

            });

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
                $scope.note.exchange_currency = $scope.currencySelected.exchange_rate;
                currencySelected($scope.billing.currency_id);
            });

            $scope.sale = $scope.data.sale;
            $scope.products = $scope.data.detail;
            $scope.movements = $scope.data.movements;

            // $scope.sale.date_sale = $scope.entity.date_sale;

            $scope.voucher_ruc = VOUCHER['FACTURA'];
            $scope.voucher_boleta = VOUCHER['BOLETA'];
            $scope.voucher_income = VOUCHER['RECIBO_INGRESO'];
            $scope.voucher_expense = VOUCHER['RECIBO_EGRESO'];


            $timeout(function () {
                $('#date_document').datepicker({
                    dateFormat: 'yy-mm-dd',
                    autoclose: true,
                });

                $('[data-toggle="tooltip"]').tooltip();

            }, 100);
        }

        $scope.changeTypeVoucher = function (typeVoucher) {
            $scope.typeVoucherSelected = typeVoucher;
        }

        function currencySelected(id) {
            if(!_.isUndefined(id)){
                $scope.currencySelected = ConfigPagination.searchById(id,$scope.currency);
            }
        }

        function getSerieVoucher(voucher_id) {
            RESTService.get('config/voucher/serie', voucher_id, function (response) {
                $scope.series = response.results;
                $scope.serieSelected = response.results[0];
            });
        }

        function getBillingCodes(voucher_id) {
            RESTService.get('config/billingcodes', voucher_id, function (response) {
                $scope.typenotes = response.results;
                $scope.typeNoteSelected = response.results[0];
            });
        }


        $scope.saveNote = function () {

            if (validate()) {
                var data = {};
                $scope.note['movement_id'] = $scope.billing.id;
                $scope.note['billingcode_id'] = $scope.typeNoteSelected.id;
                $scope.note['currency_id'] = $scope.currencySelected.id;
                $scope.note['paymentmethod_id'] = $scope.billing.paymentmethod_id;
                $scope.note['typevoucher_id'] = $scope.typeVoucherSelected.id;
                $scope.note['client_id'] = $scope.billing.client_id;
                $scope.note['serie'] = $scope.serieSelected.series;
                $scope.note['igv'] = $scope.sale.igv;
                $scope.note['subtotal'] = $scope.sale.subtotal;
                $scope.note['discount'] = 0;
                $scope.note['total'] = $scope.sale.total;
                $scope.note['text_amount'] = $scope.billing.text_amount;

                data.note = $scope.note;
                data.detail = $scope.products;

                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro de confirmar la emisión de "+$scope.typeVoucherSelected.description+" para el comprobante "+ $scope.billing.nro_voucher+" ?",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };

                AlertFactory.confirmWarning(options, function () {
                    RESTService.save('billing/notedocuments/save', data, function (result) {
                        notifyAlert.success("Proceso realizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });

            }
        };


        function validate() {

            if (_.isUndefined($scope.note.date_document) || _.isNull($scope.note.date_document)) {
                HelperFactory.show_AlertFactory('Debe seleccionar la fecha de emisión');
                angular.element(document.querySelector('#date_document')).focus();
                return false;
            }

            if (_.isNull($scope.note.motive)) {
                HelperFactory.show_AlertFactory('Debe especificar el motivo');
                angular.element(document.querySelector('#motive')).focus();
                return false;
            }

            return true;
        }

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };
    }

})();
