(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendCancelledVoucherCtrl', ExtendCancelledVoucherCtrl);

    ExtendCancelledVoucherCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout'];

    function ExtendCancelledVoucherCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout) {

        $scope.amount_opening = null;
        $scope.voucher = PARAM.voucher;

        $scope.cancelled = {
            'motive_cancelled': null,
            'affect_moneybox': true
        }

        $timeout(function () {
            angular.element(document.querySelector('#motive_cancelled')).focus();
        }, 100);

        $scope.save = function () {
            if (validate()) {
                $scope.cancelled['movement_id'] = $scope.voucher.id;
                $scope.cancelled['sale_id'] = $scope.voucher.sale_id;

                var data = {};
                data.cancelled = $scope.cancelled;

                RESTService.save('billing/cancelledvoucher', data, function (result) {
                    notifyAlert.success("Comprobante anulado con éxito!!");
                    $uibModalInstance.close(result);
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };

        function validate() {
            if (_.isNull($scope.cancelled.motive_cancelled)) {
                HelperFactory.show_AlertFactory('Debe ingresar el motivo de anulación del comprobante.');
                angular.element(document.querySelector('#motive_cancelled')).focus();
                return false;
            }

            return true;
        }

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };
    }

})();
