(function () {
    'use strict';
    angular.module('sys.app.vouchers')
        .controller('BillingVoucherCtrl', BillingVoucherCtrl);

    BillingVoucherCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal', 'EXPORT'];


    function BillingVoucherCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal, EXPORT) {

        $scope.entity = {};
        $scope.text = null;
        $scope.currentPage = 1;
        var object = "";

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        $scope.envioSelected = {id: null, description:'TODOS', value:null};

        init();

        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage +'&sunat_envio='+$scope.envioSelected.id+
                "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
            RESTService.all('billing/vouchers', object, function (response) {

                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

            }, function (error) {
                console.log('ERROR');
                return false;
            });

        };

        function sync() {
            RESTService.all('config/typevoucher/sale', null, function (response) {
                var last = response.results.length;
                $scope.typevouchers = response.results;
                response.results[last] = {id: null, description: 'TODOS', value: null};
                $scope.typeVoucherSelected = response.results[last];
            });


            $scope.sunatenvios = EXPORT.SUNAT_ENVIO;
            $scope.envioSelected = EXPORT.SUNAT_ENVIO[0];

            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                        init();
                    }
                );
            }, 50);

        };

        $scope.changeEnvioSelected = function (item) {
            $scope.envioSelected = item;
            $("#searchInput").val('');
            $scope.text = null;
            init();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('billing.vouchers', {entity: null}, {'reload': true});
        };

        $scope.pageChanged = function (page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.cancelledVoucher = function (item) {
            var obj = {'voucher': item};
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/billing/voucher/cancelledvoucher.html',
                controller: 'ExtendCancelledVoucherCtrl',
                size: 'modal-dialog modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                init();
            });
        };

        $scope.associateSale = function (sale_id) {
            RESTService.get('sales/detail', sale_id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/sales/sale/modaldetail.html',
                    controller: 'ModalDetailSaleCtrl',
                    size: 'modal-dialog modal-lg',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        $scope.generateCreditNote = function (billing) {
            RESTService.get('sales/detail', billing.sale_id, function (response) {
                var obj = {'data': response.data, 'billing':billing};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/billing/creditnotes/modalcreditnote.html',
                    controller: 'ModalCreditNoteCtrl',
                    size: 'modal-dialog modal-xl',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                }).result.then(function (result) {
                    init();
                });
            });
        };


        $scope.printVoucher = function (item) {
            RESTService.get('billing/print/voucher', item.id, function (response) {
                window.open('/print/billing/document/'+ response.sale_id)
            });
        }

        $scope.export = function (item) {
            var obj = {
                'start_range': $scope.start_range,
                'end_range': $scope.end_range,
                'typevouchers': $scope.typevouchers,
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/billing/voucher/export.html',
                controller: 'ExportVoucherCtrl',
                size: 'modal-dialog',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                init();
            });
        };

        $scope.sendVoucher = function (item) {

            var options = {
                title: "¡Atención!",
                message: "¿Esta seguro(a) de enviar el comprobante a Sunat?",
                cancel: "Cancelar",
                confirm: "Enviar comprobante"
            };

            AlertFactory.confirmWarning(options, function () {

                var data = {};
                data.movement = item;

                RESTService.save('billing/sendvoucher', data, function (result) {
                    notifyAlert.success("Comprobante enviado con éxito!!");
                    init();

                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            });

        };

        $scope.downloadXml = function (item) {
            RESTService.all('company/url_download_xml', null, function (response) {
                window.open(response.url_download + item.billing_external_id);
            });
        };

        $scope.sendEmailBilling = function (item) {

            RESTService.get('billing/print/voucher', item.id, function (response) {
                swal({
                    title: '<span class="f-s-16">Enviar por correo el comprobante <span class="text-success bold">'+item.nro_voucher+'</span></span>',
                    input: 'email',
                    inputPlaceholder: "Ingrese correo, Ejem: cliente@gmail.com",
                    showCancelButton: true,
                    confirmButtonColor: "#30419b",
                    confirmButtonText: "<i class='fas fa-envelope m-r-5'></i>Confirmar envío",
                    cancelButtonText: "Cancelar"
                }).then(function (email) {
                    if(email.value){
                        $("#loading_object").show();
                        $.ajax({
                            url: '/send/email/billing/'+ response.sale_id,
                            type: 'GET',
                            data: {
                                email:email.value
                            },
                            success: function(response) {
                                $("#loading_object").hide();
                                swal({
                                    type: 'success',
                                    title:'Excelente !!',
                                    html:response.msg
                                })
                            },
                            error: (function (error) {
                                $("#loading_object").hide();
                                swal({
                                    type: 'error',
                                    title:'Hubo un error !!',
                                    html: "Hubo un error al realizar el envío. Para mayor información consulte a su administrador." + error
                                })
                            })
                        });
                    }
                });

            });
        };
    }

})();


