
(function () {
    'use strict';

    angular.module('sys.app.catalog').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];


    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider

            .state('catalog.products', {
                url: '/productos',
                templateUrl: '../../templates/catalog/product.html',
                controller: 'ProductCtrl',
                params: {
                    entity: null
                },
                title: "Productos",
                module:"products"
            })

            .state('catalog.servicesproduct', {
                url: '/servicios',
                templateUrl: '../../templates/catalog/services.html',
                controller: 'ServicesCtrl',
                params: {
                    entity: null
                },
                title: "Servicios",
                module:"servicesproduct"
            })

            .state('catalog.categories', {
                url: '/categorias',
                templateUrl: '../../templates/catalog/category.html',
                controller: 'CategoryCtrl',
                params: {
                    entity: null
                },
                title: "Categorías",
                module:"categories"
            })

            .state('catalog.lines', {
                url: '/lineas',
                templateUrl: '../../templates/catalog/line.html',
                controller: 'LineCtrl',
                params: {
                    entity: null
                },
                title: "Líneas",
                module:"lines"
            })

            .state('catalog.brands', {
                url: '/marcas',
                templateUrl: '../../templates/catalog/brand.html',
                controller: 'BrandCtrl',
                params: {
                    entity: null
                },
                title: "Marcas",
                module:"brands"
            })

            .state('catalog.variants', {
                url: '/variantes',
                templateUrl: '../../templates/catalog/variant.html',
                controller: 'VariantCtrl',
                params: {
                    entity: null
                },
                title: "Variantes",
                module:"variants"
            })
        ;

        $urlRouterProvider.otherwise('/productos');
    }

})();
