(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendCategoryCtrl', ExtendCategoryCtrl);

    ExtendCategoryCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout','fileReader', 'CLIENT', 'TYPE_DOCUMENT', '$uibModal'];

    function ExtendCategoryCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, fileReader, CLIENT, TYPE_DOCUMENT, $uibModal) {

        var loading;

        $scope.get_param = PARAM;
        $scope.entity = $scope.get_param.entity;
        $scope.category = $scope.entity;

        if ($scope.get_param.id != 0) {
            $scope.txt_title = 'Editar'
            $scope.action = 'edit';
            $scope.category.description = $scope.entity.description;
            $scope.category.description_content = $scope.entity.description_content;
        }
        else
        {
            $scope.txt_title = 'Registrar';
            $scope.action = 'create';
            $scope.category = {
                'description': null,
                'description_content': null
            };
        }

        init()

        function init() {

            $timeout(function () {
                loading = angular.element(document.querySelector('#loading_modal'));
                angular.element(document.querySelector('#category_description')).focus();
            }, 100);
        }

        $scope.save = function () {
            if (validate()) {

                loading.show();

                if($scope.action == 'create'){
                    RESTService.save('category/save', $scope.category, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        loading.hide();
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('category/update', $scope.category.id, $scope.category, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('catalog.brands', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.category.description) || _.isEmpty($scope.category.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción de la categoría');
                angular.element(document.querySelector('#category_description')).focus();
                return false;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
            // $uibModalInstance.dismiss('Cancelado');
            $("#loading_object").css("display","none");
        };
    }

})();
