(function () {

    'use strict';
    angular.module('sys.app.category.new')
        .controller('NewCategoryCtrl', NewCategoryCtrl);

    NewCategoryCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory'];

    function NewCategoryCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory) {
        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.category = $stateParams.entity;
                if ($scope.category.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.category.description = $scope.entity.description;
                    $scope.category.description_content = $scope.entity.description_content;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.category = {
                        'description': null,
                        'description_content': null
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('catalog.categories', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {
            angular.element(document.querySelector('#category_description')).focus();
        }

        $scope.save = function () {
            if (validate()) {
                if($scope.action == 'create'){
                    RESTService.save('category/save', $scope.category, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('catalog.categories', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('category/update', $scope.category.id, $scope.category, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('catalog.categories', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.category.description) || _.isEmpty($scope.category.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción de la categoría');
                angular.element(document.querySelector('#category_description')).focus();
                return false;
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('catalog.categories', null, {'reload': true});
        };

    }

})();

