(function () {
    'use strict';
    angular.module('sys.app.line')
        .controller('LineCtrl', LineCtrl);

    LineCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH'];

    function LineCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;

        var default_category = {id: null, description:'Todos', value:null};
        $scope.categorySelected =default_category;

        var object = "";

        init();

        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage+'&category='+$scope.categorySelected.id;
            RESTService.all('line/list', object + '&export=0', function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        function sync() {
            RESTService.all('category/search/all', null, function (response) {
                var last = response.results.length;
                $scope.categories = response.results;
                response.results[last] = {id: null, description:'Todos', value:null};
                $scope.categorySelected = response.results[last];
            });
        }

        $scope.changeCategory = function (item) {
            $scope.categorySelected = item;
            $("#searchInput").val('');
            $scope.text = null;
            init();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('catalog.lines', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var source = {'id': 0};
            $state.transitionTo('catalog.lines.new', {entity: source}, {
                'reload': 'catalog.lines.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('line/edit', source.id, function (response) {
                $state.transitionTo("catalog.lines.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "catalog.lines.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('line/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('catalog.lines', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };
    }
})();



