(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendLineCtrl', ExtendLineCtrl);

    ExtendLineCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout', 'fileReader', 'CLIENT', 'TYPE_DOCUMENT', '$uibModal'];

    function ExtendLineCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, fileReader, CLIENT, TYPE_DOCUMENT, $uibModal) {

        var loading;

        $scope.get_param = PARAM;
        $scope.entity = $scope.get_param.entity;
        $scope.line = $scope.entity;

        if ($scope.get_param.id != 0) {
            $scope.txt_title = 'Editar'
            $scope.action = 'edit';
            $scope.line.description = $scope.entity.description;
        } else {
            $scope.txt_title = 'Registrar';
            $scope.action = 'create';
            $scope.line = {
                'description': null,
            };
        }

        init()

        function init() {

            RESTService.all('category/search/all', null, function (response) {
                $scope.categories = response.results;
                $scope.category_exists = false;
                if ($scope.categories.length > 0) {
                    $scope.category_exists = true;
                }
                listCategory();
            });

            $timeout(function () {
                loading = angular.element(document.querySelector('#loading_modal'));
                angular.element(document.querySelector('#line_description')).focus();
            }, 100);
        }

        function listCategory() {
            $timeout(function () {
                $('#categorySelected').select2();
                var last = $scope.categories.length;
                $scope.categories[last] = {id: 0, description: 'Seleccione', value: 0};
                $.each($scope.categories, function (i, item) {
                    $("#categorySelected").append($('<option>', {
                        value: item.id,
                        text: item.description
                    }));
                });
                $("#categorySelected").val($scope.categories[last].id);
                categorySelected($scope.line.category_id);
            }, 100);
        }

        function categorySelected(id) {
            if (_.isUndefined(id)) {
                id = null;
            }

            if (!_.isNull(id)) {
                $('#categorySelected').find('option:selected').removeAttr('selected');
                $('#categorySelected').val(id);
                $('#categorySelected').change();
            }
        }

        $scope.changeCategory = function (item) {
            $scope.categorySelected = item;
        };

        $scope.save = function () {
            if (validate()) {
                $scope.line['category_id'] = $("#categorySelected").val();
                if ($scope.action == 'create') {
                    RESTService.save('line/save', $scope.line, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                } else if ($scope.action == 'edit') {
                    RESTService.updated('line/update', $scope.line.id, $scope.line, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('catalog.lines', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.line.description) || _.isEmpty($scope.line.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción de la línea');
                angular.element(document.querySelector('#line_description')).focus();
                return false;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
            $("#loading_object").css("display", "none");
        };

        $scope.addCategory = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/catalog/category/extends.html',
                controller: 'ExtendCategoryCtrl',
                size: 'sm',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var past = $scope.category_exists;
                    $scope.category_exists = true;
                    if (past == false) {
                        $('#categorySelected').select2();
                    }
                    $timeout(function () {
                        var data = result.data;
                        var last = $scope.categories.length;
                        $scope.categories[last] = data;

                        $("#categorySelected").append($('<option>', {
                            value: data.id,
                            text: data.description
                        }));
                        categorySelected(data.id);

                    }, 100);
                }
            });
        };
    }

})();

