(function () {

    'use strict';
    angular.module('sys.app.line.new')
        .controller('NewLineCtrl', NewLineCtrl);

    NewLineCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert','_', 'HelperFactory', 'ConfigPagination', '$uibModal', '$timeout'];

    function NewLineCtrl($scope, $stateParams, $state, RESTService, notifyAlert,_, HelperFactory, ConfigPagination, $uibModal, $timeout) {
        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.line = $stateParams.entity;
                if ($scope.line.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.line.description = $scope.entity.description;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.line = {
                        'description': null,
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('catalog.lines', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {

            RESTService.all('category/search/all', null, function (response) {
                $scope.categories = response.results;
                $scope.category_exists = false;
                if($scope.categories.length>0){
                    $scope.category_exists = true;
                }

                listCategory();
            });

            angular.element(document.querySelector('#line_description')).focus();
        }
        
        function listCategory() {
            $timeout(function () {
                $('#categorySelected').select2();
                var last = $scope.categories.length;
                $scope.categories[last] = {id: 0, description:'Seleccione', value:0};
                $.each($scope.categories, function (i, item) {
                    $("#categorySelected").append($('<option>', {
                        value: item.id,
                        text : item.description
                    }));
                });
                $("#categorySelected").val($scope.categories[last].id);
                categorySelected($scope.line.category_id);
            }, 100);
        }

        function categorySelected(id) {
            if(_.isUndefined(id)){
                id = null;
            }
            
            if(!_.isNull(id)){
                $('#categorySelected').find('option:selected').removeAttr('selected');
                $('#categorySelected').val(id);
                $('#categorySelected').change();
            }
        }

        $scope.changeCategory = function (item) {
            $scope.categorySelected = item;
        };

        $scope.save = function () {
            if (validate()) {
                $scope.line['category_id'] = $("#categorySelected").val();
                if($scope.action == 'create'){
                    RESTService.save('line/save', $scope.line, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('catalog.lines', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('line/update', $scope.line.id, $scope.line, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('catalog.lines', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.line.description) || _.isEmpty($scope.line.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción de la línea');
                angular.element(document.querySelector('#line_description')).focus();
                return false;
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('catalog.lines', null, {'reload': true});
        };

        $scope.addCategory = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/catalog/category/extends.html',
                controller: 'ExtendCategoryCtrl',
                size: 'sm',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var past = $scope.category_exists;
                    $scope.category_exists = true;
                    if(past == false){
                        $('#categorySelected').select2();
                    }
                    $timeout(function () {
                        var data = result.data;
                        var last = $scope.categories.length;
                        $scope.categories[last] = data;

                        $("#categorySelected").append($('<option>', {
                            value: data.id,
                            text : data.description
                        }));
                        categorySelected(data.id);

                    }, 100);
                }
            });
        };

    }

})();

