(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ModalStockProductCtrl', ModalStockProductCtrl);

    ModalStockProductCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout', 'SEARCH'];

    function ModalStockProductCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, SEARCH) {


        var object = "";
        $("#brandSelected").val(0);
        $("#lineSelected").val(0);
        $scope.warehousesSelected = {
            'id':1
        };

        $scope.currentPage = 1;
        $scope.text= null;
        $scope.stock_min = null;
        $scope.product = null;

        $scope.products_selected = [];

        $scope.view_selected = false;

        init();
        sync();

        function init() {
            object = "search=" + $scope.text +'&page=' + $scope.currentPage+'&warehouse='+$scope.warehousesSelected.id
                +"&stock_min="+$scope.stock_min+"&brand="+$("#brandSelected").val()+"&line="+$("#lineSelected").val();

            RESTService.all('rcatalog/product_stock', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

                $timeout(function () {
                    checkProductSelected();
                }, 100);
            });
        };

        function sync() {

            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
            });

            RESTService.all('brand/search/all', null, function (response) {
                $scope.brands = response.results;
                $scope.brand_exists = false;
                if($scope.brands.length>0){
                    $scope.brand_exists = true;
                }

                $('#brandSelected').select2();
                var last = $scope.brands.length;
                $scope.brands[last] = {id: 0, description:'Seleccione', value:null};
                $.each($scope.brands, function (i, item) {
                    $("#brandSelected").append($('<option>', {
                        value: item.id,
                        text : item.description
                    }));
                });
                $("#brandSelected").val($scope.brands[last].id);

            });

            RESTService.all('line/search/all', null, function (response) {
                $scope.lines = response.results;
                $scope.line_exists = false;
                if($scope.lines.length>0){
                    $scope.line_exists = true;
                }

                $('#lineSelected').select2();
                var last = $scope.lines.length;
                $scope.lines[last] = {id: 0, description:'Seleccione', value:null};
                $.each($scope.lines, function (i, item) {
                    $("#lineSelected").append($('<option>', {
                        value: item.id,
                        text : item.description
                    }));
                });
                $("#lineSelected").val($scope.lines[last].id);
            });

        };

        $scope.removeProductSelected = function (product) {
            var index = $scope.products_selected.findIndex(function (obj) {return obj.id == product.id })
            $scope.products_selected.splice(index, 1);
        };

        $scope.selectedProductStock = function (product) {
            var check = $("#branch_"+product.id);

            if(check.is(":checked")){
                var unique = ifProductSelected(product);
                if(unique){
                    $scope.products_selected.push(product);
                }
            }
            else{
                var index = $scope.products_selected.findIndex(function (obj) {return obj.id == product.id })
                $scope.products_selected.splice(index, 1);
            }
        };


        function ifProductSelected(obj) {
            var cart = $scope.products_selected;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        }

        function checkProductSelected() {
            $.each($scope.products_selected, function (i, item) {
                $("#branch_"+item.id).prop('checked', true);
            });
        };


        $scope.filter = function () {
            $scope.currentPage = 1;
            init();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.cleanSearch = function () {
            $timeout(function () {
                $scope.text = null;
                $scope.searchInput = null;
                angular.element(document.querySelector('#searchInput')).val('');
                angular.element(document.querySelector('#searchInput')).focus();
                init();

            }, 50);
        };

        $scope.refresh = function () {
            $scope.currentPage = 1;
            $scope.text = null;
            $scope.searchInput = null;
            angular.element(document.querySelector('#searchInput')).val('');

            $scope.stock_min = null;
            $("#stock_min").val('');
            $("#brandSelected").empty();
            $("#lineSelected").empty();

            init();
            sync();
        };

        $scope.showViewSelected = function () {
            if($scope.view_selected){
                $scope.view_selected = false;
                $("#view_selected").removeClass('show').addClass('hide');
                $("#content_selected").removeClass('hide').addClass('show');
                init();
            }
            else {
                $scope.view_selected = true;
                $("#content_selected").removeClass('show').addClass('hide');
                $("#view_selected").removeClass('hide').addClass('show');
            }
        };

        $scope.confirmSelected = function () {
            if (validate()) {
                swal({
                    title: "Aviso!",
                    html: 'Los productos seleccionados se agregarán al detalle.',
                    type: "info",
                    showCancelButton: true,
                    confirmButtonColor: "#30419b",
                    cancelButtonClass: 'btn btn-secondary ml-2',
                    confirmButtonText: 'Confirmar <i class="fas fa-check m-r-5"></i>',
                    cancelButtonText: "Cancelar",
                }).then(function (isConfirm) {
                    if (isConfirm.value == true) {
                        $uibModalInstance.close($scope.products_selected);
                    }
                });
            }
        };

        function validate() {
            if ($scope.products_selected.length === 0) {
                HelperFactory.show_AlertFactory('Debe seleccionar al menos un producto para confirmar.');
                angular.element(document.querySelector('#search_product_value')).focus();
                return false;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };

    }

})();
