(function () {

    'use strict';
    angular.module('sys.app.product.new')
        .controller('NewProductCtrl', NewProductCtrl);

    NewProductCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PRODUCT', '$uibModal', '$timeout'];

    function NewProductCtrl($scope, $stateParams, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PRODUCT, $uibModal, $timeout) {

        var typeprice = PRODUCT.TYPEPRICE;
        var typeproduct = PRODUCT.TYPEPRODUCT;
        $scope.is_price_general = typeprice[0];
        $scope.is_price_unit = typeprice[1];
        $scope.is_price_variant = typeprice[2];
        $scope.is_service = typeproduct[1];

        $scope.is_edit = false;

        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.product = $stateParams.entity;

                if ($scope.product.id != 0) {//$scope.unitElements
                    $scope.is_edit = true;
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.is_create = false;
                    $scope.status_code = false;
                    $scope.product.code = $scope.entity.code;
                    $scope.product.description = $scope.entity.description;
                    $scope.product.url_image = $scope.entity.urlImageBase;

                    $scope.product.is_show = $scope.entity.is_show;
                    $scope.product.is_favorite = $scope.entity.is_favorite;
                    $scope.product.is_control_stock = $scope.entity.is_control_stock;
                    $scope.product.is_limit_stock = $scope.entity.is_limit_stock;
                    $scope.product.limit_stock = $scope.entity.limit_stock;

                    $scope.product.is_control_expiration = $scope.entity.is_control_expiration;
                    $scope.product.is_limit_expiration = $scope.entity.is_limit_expiration;
                    $scope.product.limit_expiration = $scope.entity.limit_expiration;

                    // price_general
                    if ($scope.product.typeprice_id == $scope.is_price_general.id) {
                        $scope.price_general = $scope.product.price_general;
                    }

                    // price_by_units_measure
                    if ($scope.product.typeprice_id == $scope.is_price_unit.id) {
                        $scope.unitprices = $scope.product.unitprices;
                        $scope.unitSelected = $scope.unitprices[0];
                        getUnitChilds($scope.unitSelected);
                    }

                    // price_by_variants

                    if ($scope.product.typeprice_id == $scope.is_price_variant.id) {
                        $scope.variantprices = $scope.product.variantprices;
                        getVariants();
                    }

                    if(!_.isUndefined($scope.product.is_grouped)){
                        if($scope.product.is_grouped){
                            $scope.productgroupeds = $scope.product.productgroupeds;
                        }
                    }

                    $scope.stock_general = {};
                    if ($scope.product.is_control_stock) {
                        $scope.stock_general = $scope.product.stock_general;
                    }

                    generateBarcode($scope.product.code);
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.is_create = true;
                    $scope.status_code = false;
                    $scope.product = {
                        'code': null,
                        'description': null,
                        'comment': null,
                        'price_sale': null,
                        'is_show': true,
                        'is_favorite': false,
                        'is_control_stock': false,
                        'is_limit_stock': false,
                        'limit_stock': null,
                        'is_control_expiration': false,
                        'is_limit_expiration': false,
                        'limit_expiration': null,
                        'is_grouped': false,
                        'url_image': null
                    };

                    // is price general
                    $scope.price_general = {
                        'price_purchase': null,
                        'price_min': null,
                        'price_sale': null,
                        'price_credit': null,
                        'price_wholesaler': null,
                    }
                    // is price x unit
                    $scope.unitchilds = [];
                    $scope.unitprices = [];
                    $scope.variantprices = [];
                    $scope.productgroupeds = [];

                    // STOCK product
                    $scope.stock_general = {
                        'stock': 0,
                    }
                }
            }
        }
        catch (e) {
            $state.transitionTo('catalog.products', null, {'reload': true});
            console.log(e);
            return false;
        }

        init();

        function init() {

            $scope.type_products = PRODUCT.TYPEPRODUCT;
            $scope.typeProductSelected = PRODUCT.TYPEPRODUCT[0];
            typeProductSelected($scope.product.type_product);

            // RESTService.all('system/typeproduct', null, function (response) {
            //     $scope.type_products = response.results;
            //     $scope.typeProductSelected = response.results[0];
            //     typeProductSelected($scope.product.type_product);
            //
            // });

            RESTService.all('warehouses/principal', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
            });

            RESTService.all('config/unitsmeasure/parents', null, function (response) {
                $scope.units = response.results;
                if (!$scope.is_create) {
                    if ($scope.product.typeprice_id == $scope.is_price_general.id) {
                        $scope.price_general = $scope.product.price_general;
                        unitSelected($scope.price_general.unit_id);
                    }
                    // price_by_units_measure
                    if ($scope.product.typeprice_id == $scope.is_price_unit.id) {
                        unitSelected($scope.unitprices[0].id);
                    }

                    // price_by_variants
                    if ($scope.product.typeprice_id == $scope.is_price_variant.id) {
                        unitSelected($scope.variantprices[0].unit_id);
                    }

                } else {
                    $scope.unitSelected = response.results[0];
                }
            });

            RESTService.all('catalog/typeprice', null, function (response) {
                $scope.typeprices = response.results;
                $scope.typePriceSelected = response.results[0];
                typePriceSelected($scope.product.typeprice_id);
            });

            RESTService.all('brand/search/all', null, function (response) {
                $scope.brands = response.results;
                $scope.brand_exists = false;
                if ($scope.brands.length > 0) {
                    $scope.brand_exists = true;
                }
                listBrand();
            });

            RESTService.all('line/search/all', null, function (response) {
                $scope.lines = response.results;
                $scope.line_exists = false;
                if ($scope.lines.length > 0) {
                    $scope.line_exists = true;
                }
                listLine();
            });

            angular.element(document.querySelector('#product_description')).focus();

            $timeout(function () {
                $('[data-toggle="tooltip"]').tooltip();


            }, 3000);
        }

        function generateBarcode(code) {
            $("#barcode").barcode(
                code, // Valor del codigo de barras
                "code128" // tipo (cadena)
            );
        }

        $scope.setCodeProduct = function (code) {
            if (code.length > 0) {
                generateBarcode(code);
            }
            else {
                $("#barcode").empty();
            }
        };

        function listBrand() {
            $timeout(function () {
                $('#brandSelected').select2();
                var last = $scope.brands.length;
                $scope.brands[last] = {id: 0, description: 'Seleccione', value: 0};
                $.each($scope.brands, function (i, item) {
                    $("#brandSelected").append($('<option>', {
                        value: item.id,
                        text: item.description
                    }));
                });
                $("#brandSelected").val($scope.brands[last].id);

                brandSelected($scope.product.brand_id);
            }, 100);

        }

        function listLine() {
            $timeout(function () {
                $('#lineSelected').select2();
                var last = $scope.lines.length;
                $scope.lines[last] = {id: 0, description: 'Seleccione', value: 0};
                $.each($scope.lines, function (i, item) {
                    $("#lineSelected").append($('<option>', {
                        value: item.id,
                        text: item.description
                    }));
                });
                $("#lineSelected").val($scope.lines[last].id);

                lineSelected($scope.product.line_id);
            }, 100);

        }

        function unitSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.unitSelected = ConfigPagination.searchById(id, $scope.units);
            }
        }

        function typePriceSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.typePriceSelected = ConfigPagination.searchById(id, $scope.typeprices);
            }
        }

        function typeProductSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.typeProductSelected = ConfigPagination.searchById(id, $scope.type_products);
            }
        }

        function brandSelected(id) {
            if (_.isUndefined(id)) {
                id = null;
            }
            if (!_.isNull(id)) {
                $('#brandSelected').find('option:selected').removeAttr('selected');
                $('#brandSelected').val(id);
                $('#brandSelected').change();
            }
        }

        function lineSelected(id) {
            if (_.isUndefined(id)) {
                id = null;
            }
            if (!_.isNull(id)) {
                $('#lineSelected').find('option:selected').removeAttr('selected');
                $('#lineSelected').val(id);
                $('#lineSelected').change();
            }
        }

        $scope.changeTypeProduct = function (item) {
            $scope.typeProductSelected = item;
            if (item.id == $scope.is_service.id) {
                $scope.typePriceSelected = $scope.typeprices[0];
                $scope.unitSelected = $scope.units[0];
            }
        };

        $scope.changeIsControlStock = function (item) {
            if (!$scope.is_create) {
                if (_.isUndefined($scope.stock_general) || _.isNull($scope.stock_general)) {
                    $scope.stock_general = {
                        'stock': 0
                    }
                }
                else {
                    $scope.stock_general['stock'] = 0;
                }
            }
        };

        $scope.changeIsLimitExpiration = function (item) {
            if (item) {
                // days default motnh interval 30
                $scope.product.limit_expiration = 30;
                $("#limit_expiration").val(30);
            } else {
                $scope.product.limit_expiration = null;
                $("#limit_expiration").val('');
            }
        }

        $scope.changeUnitSelected = function () {
            if ($scope.typePriceSelected.id == $scope.is_price_unit.id) {
                getUnitChilds();
            }
        };

        $scope.changeTypePriceSelected = function (item) {
            if (item.id == $scope.is_price_unit.id) {
                $scope.is_edit = false;
                getUnitChilds();
            }
            else if (item.id == $scope.is_price_general.id) {
                $scope.price_general = {
                    'price_purchase': null,
                    'price_min': null,
                    'price_sale': null,
                    'price_credit': null,
                    'price_wholesaler': null,
                }
            }
            else if (item.id == $scope.is_price_variant.id) {
                getVariants();
            }
        };

        function getVariants() {
            RESTService.all('variant/search/all', null, function (response) {
                $scope.variants = response.results;

                if ($scope.variants.length > 0) {
                    var last = $scope.variants.length;
                    var default_obj = {id: 0, description: 'Seleccione', value: 0};
                    $scope.variants[last] = default_obj;
                    $scope.variantSelected = default_obj;
                }
            });
        }

        function getUnitChilds(unit_id) {
            if (!$scope.is_edit) {
                $scope.unitprices = [];
            }
            var unit_id = $scope.unitSelected.id;
            RESTService.get('config/unitsmeasure/childs', unit_id, function (response) {
            // RESTService.all('config/unitsmeasure/all/childs', null, function (response) {
                $scope.unitchilds = response.results;
                $scope.unitChildSelected = response.results[0];
                // add unit principal
                if (!$scope.is_edit) {
                    $scope.unitprices.push($scope.unitSelected);
                }
                $scope.is_edit = false;
            });
        };

        $scope.addUnitPrice = function () {
            var item = $scope.unitChildSelected;
            var unique = ifExistUnitChild(item);
            if (unique) {
                item.detail_id = null;

                $scope.unitprices.push(item);
            }
            else {
                notifyAlert.warning('La unidad ' + item.description + ' ya se encuentra agregado');
            }
        }

        function ifExistUnitChild(obj) {
            var cart = $scope.unitprices;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        };


        $scope.changeVariantSelected = function () {
            console.log("change variant");
        }

        $scope.showTypeVariants = function (variant) {
            if (variant.id != 0) {
                var url = 'variant/search/types';
                var object = "variant_id=" + variant.id
                RESTService.all(url, object, function (response) {
                    $scope.variantprices = response.data;
                    $.each(response.data, function (i, item) {
                        var pos = $scope.variantprices.indexOf(item);
                        $scope.variantprices[pos].is_active = false;
                        $scope.variantprices[pos].equivalence = null;
                        $scope.variantprices[pos].price = null;
                    });
                });
            }
            else {
                notifyAlert.warning("Seleccione una opción válida para listar tipos de variante!");
            }
        }


        $scope.selectedProduct = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;
                var unique = ifExistProduct(item);
                if (unique) {

                    if(!$scope.is_create){
                        if($scope.product.id == item.id){
                            notifyAlert.warning('No se puede agrupar al MISMO producto que se va editar');
                            angular.element(document.querySelector('#search_product_value')).focus();
                            return false;
                        }
                    }

                    $scope.productgroupeds.push(item);
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_product');
                    angular.element(document.querySelector('#search_product_value')).focus();
                }
                else {
                    notifyAlert.warning('El producto ' + item.description + ' ya se encuentra agregado');
                    angular.element(document.querySelector('#search_product_value')).focus();
                }
            }
        }

        function ifExistProduct(obj) {
            var cart = $scope.productgroupeds;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        }

        $scope.removeItem = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.productgroupeds.indexOf(product);
            $scope.productgroupeds.splice(index, 1)
            notifyAlert.info("El producto " + product.description + ' ha sido removido del detalle');
        };

        $scope.recalculate_equivalence = function (count, unit, $index) {
            var check_quantity = angular.element(document.querySelector('#equivalence' + $index)).val();
            var q_ = check_quantity;
            angular.element(document.querySelector('#equivalence' + $index)).val(q_);
            var quantity = angular.element(document.querySelector('#equivalence' + $index)).val();
            if (!_.isNaN(quantity * 1)) {
                var index = $scope.unitprices.indexOf(unit);
                $scope.unitprices[index].equivalence = quantity;
            }
        };

        $scope.recalculate_equivalence_variant = function (count, unit, $index) {
            var check_quantity = angular.element(document.querySelector('#equivalencevariant' + $index)).val();
            var q_ = check_quantity;
            angular.element(document.querySelector('#equivalencevariant' + $index)).val(q_);
            var quantity = angular.element(document.querySelector('#equivalencevariant' + $index)).val();
            if (!_.isNaN(quantity * 1)) {
                var index = $scope.variantprices.indexOf(unit);
                $scope.variantprices[index].equivalence = quantity;
            }
        };

        $scope.recalculate_price = function (price, unit, $index) {
            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();
            if (!_.isNaN(price_get * 1)) {
                var index = $scope.unitprices.indexOf(unit);
                $scope.unitprices[index].price = Number(price_get);
            }
        };

        $scope.recalculate_price_variant = function (price, unit, $index) {
            var check_price = angular.element(document.querySelector('#pricevariant' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#pricevariant' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#pricevariant' + $index)).val();
            if (!_.isNaN(price_get * 1)) {
                var index = $scope.variantprices.indexOf(unit);
                $scope.variantprices[index].price = Number(price_get);
            }
        };

        $scope.click_input_equivalence = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.removeUnitPrice = function ($event, unit, $index) {
            $event.preventDefault();
            var index = $scope.unitprices.indexOf(unit);
            $scope.unitprices.splice(index, 1);
        };

        $scope.changeUnitChildSelected = function (item) {
            $scope.unitChildSelected = item;
        }

        $scope.$on("fileProgress", function (e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });

        $scope.save = function () {
            if (validate()) {
                $scope.product['type_product'] = $scope.typeProductSelected.id;
                $scope.product['typeprice_id'] = $scope.typePriceSelected.id;
                $scope.product['brand_id'] = $("#brandSelected").val();
                $scope.product['line_id'] = $("#lineSelected").val();

                // $scope.price_general['unit_id'] = $scope.unitSelected.id;

                // control stock
                $scope.stock_general['warehouse_id'] = $scope.warehousesSelected.id;

                var data = {};
                data.product = $scope.product;
                data.price_general = $scope.price_general;
                data.stock_general = $scope.stock_general;
                data.unitprices = $scope.unitprices;
                data.variantprices = $scope.variantprices;
                data.productgroupeds = $scope.productgroupeds;
                data.unit_id = $scope.unitSelected.id;

                if ($scope.action == 'create') {
                    RESTService.save('product/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('catalog.products', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if ($scope.action == 'edit') {
                    RESTService.updated('product/update', $scope.product.id, data, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('catalog.products', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.product.description) || _.isEmpty($scope.product.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción del producto');
                angular.element(document.querySelector('#product_description')).focus();
                return false;
            }

            if ($scope.is_price_general.id == $scope.typePriceSelected.id) {
                if (_.isNull($scope.price_general.price_sale) || _.isEmpty($scope.price_general.price_sale)) {
                    HelperFactory.show_AlertFactory('Debe ingresar el precio de venta del producto');
                    angular.element(document.querySelector('#price_general_price_sale')).focus();
                    return false;
                }
            }
            if ($scope.product.is_control_stock) {
                if (_.isNull($scope.stock_general.stock)) {
                    HelperFactory.show_AlertFactory('Debe ingresar el stock para el producto');
                    angular.element(document.querySelector('#stock_general_stock')).focus();
                    return false;
                }
                // if($scope.is_create){
                //     if (_.isNull($scope.stock_general.stock || _.isEmpty($scope.stock_general.stock))) {
                //         HelperFactory.show_AlertFactory('Debe ingresar el stock para el producto');
                //         angular.element(document.querySelector('#stock_general_stock')).focus();
                //         return false;
                //     }
                // }
                // else{
                //
                // }
            }

            if ($scope.product.is_limit_stock) {
                if (_.isNull($scope.product.limit_stock)) {
                    HelperFactory.show_AlertFactory('Debe ingresar un valor para notficar el límite de stock');
                    angular.element(document.querySelector('#limit_stock')).focus();
                    return false;
                }
            }

            if ($scope.product.is_limit_expiration) {
                if (_.isNull($scope.product.limit_expiration)) {
                    HelperFactory.show_AlertFactory('Debe ingresar los días de antelación para notificar la fecha de vencimiento');
                    angular.element(document.querySelector('#limit_expiration')).focus();
                    return false;
                }
            }


            if ($scope.product.is_grouped) {
                if ($scope.productgroupeds.length == 0) {
                    HelperFactory.show_AlertFactory('Debe ingresar al menos un producto al detalle del producto agrupado!');
                    angular.element(document.querySelector('#search_product_value')).focus();
                    return false;
                }
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('catalog.products', null, {'reload': true});
        };

        $scope.addBrand = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/catalog/brand/extends.html',
                controller: 'ExtendBrandCtrl',
                size: 'sm',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var past = $scope.brand_exists;
                    $scope.brand_exists = true;
                    if (past == false) {
                        $('#brandSelected').select2();
                    }
                    $timeout(function () {
                        $scope.brand_exists = true;
                        var data = result.data;
                        var last = $scope.brands.length;
                        $scope.brands[last] = data;

                        $("#brandSelected").append($('<option>', {
                            value: data.id,
                            text: data.description
                        }));
                        brandSelected(data.id);
                    }, 100);
                }
            });
        };

        $scope.addLine = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/catalog/line/extends.html',
                controller: 'ExtendLineCtrl',
                size: 'sm',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var past = $scope.line_exists;
                    $scope.line_exists = true;
                    if (past == false) {
                        $('#lineSelected').select2();
                    }
                    $timeout(function () {
                        $scope.line_exists = true;
                        var data = result.data;
                        var last = $scope.lines.length;
                        $scope.lines[last] = data;

                        $("#lineSelected").append($('<option>', {
                            value: data.id,
                            text: data.description
                        }));
                        lineSelected(data.id);
                    }, 100);
                }
            });
        };
    }

})();
