(function () {
    'use strict';
    angular.module('sys.app.product')
        .controller('ProductCtrl', ProductCtrl);

    ProductCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', 'PRODUCT', '$uibModal'];

    function ProductCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, PRODUCT, $uibModal) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        var typeprice = PRODUCT.TYPEPRICE;
        $scope.is_price_general = typeprice[0];
        $scope.is_price_unit = typeprice[1];
        $scope.is_price_variant = typeprice[2];


        $scope.typeProductSelected = {id: null, description:'Todos', value:null};

        init();
        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
                // +'&typeProduct='+$scope.typeProductSelected.id;
            RESTService.all('product/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        function sync() {
            // RESTService.all('system/typeproduct', null, function (response) {
            //     var last = response.results.length;
            //     $scope.type_products = response.results;
            //     response.results[last] = {id: null, description:'Todos', value:null};
            //     $scope.typeProductSelected = response.results[last];
            // });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });
        }

        $scope.changeTypeProduct = function (item) {
            $scope.typeProductSelected = item;
            $("#searchInput").val('');
            $scope.text = null;
            init();
        };


        $scope.searchAction = function (text) {
            $scope.text = text;
            // if (text.length >= SALE.MIN_LETTERS || text.length == 0) {
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('catalog.products', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var source = {'id': 0};
            $state.transitionTo('catalog.products.new', {entity: source}, {
                'reload': 'catalog.products.new',
                'cache': false
            });
            // delete $scope.allData;
        };

        $scope.edit = function (source) {
            // if (!_.isUndefined(source)) {
            //     source = source[0];
            // }
            delete $scope.allData;
            RESTService.get('product/edit', source.id, function (response) {
                // response['current_page'] = $scope.page;
                // response['text'] = $scope.text;
                $state.transitionTo("catalog.products.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "catalog.products.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            // var source = ConfigPagination.sortDeleteid($scope.selectedItem);
            var options = {
                title: "Cuidado!!",
                message: "El producto ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('product/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('catalog.products', {entity: obj}, {'reload': true});
                    // $timeout(function () {
                    //     var obj = {"text": $scope.text};
                    //     $state.transitionTo('catalog.products', {entity: obj}, {'reload': true});
                    // }, 200);
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            });
        };


        $scope.listPriceUnit = function (product) {
            var obj = {
                'product': product,
                'currency': $scope.currencySelected
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/sale/priceunits.html',
                controller: 'ExtendsPriceUnitsCtrl',
                size: 'modal-dialog modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                // init();
            });
        };
    }
})();



