(function () {

    'use strict';
    angular.module('sys.app.servicesproduct.new')
        .controller('NewServicesProductCtrl', NewServicesProductCtrl);

    NewServicesProductCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert','_', 'HelperFactory', 'ConfigPagination', 'PRODUCT', '$uibModal', '$timeout'];

    function NewServicesProductCtrl($scope, $stateParams, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PRODUCT, $uibModal, $timeout) {

        var typeprice = PRODUCT.TYPEPRICE;
        var typeproduct = PRODUCT.TYPEPRODUCT;
        $scope.is_price_general = typeprice[0];
        $scope.is_price_unit = typeprice[1];
        $scope.is_service = typeproduct[1];

        $scope.is_edit = false;

        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.product = $stateParams.entity;

                if ($scope.product.id != 0) {//$scope.unitElements
                    $scope.is_edit = true;
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.is_create = false;
                    $scope.status_code = false;
                    $scope.product.code = $scope.entity.code;
                    $scope.product.description = $scope.entity.description;
                    $scope.product.url_image = $scope.entity.urlImageBase;

                    $scope.product.is_show = $scope.entity.is_show;
                    $scope.product.is_favorite = $scope.entity.is_favorite;

                    // price_general
                    if($scope.product.typeprice_id == $scope.is_price_general.id){
                        $scope.price_general = $scope.product.price_general;
                    }

                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.is_create = true;
                    $scope.status_code = false;
                    $scope.product = {
                        'code': null,
                        'description': null,
                        'price_sale': null,
                        'is_show': true,
                        'is_favorite': false,
                        'url_image':null
                    };

                    // is price general
                    $scope.price_general = {
                        'price_purchase':null,
                        'price_min':null,
                        'price_sale':null,
                        'price_credit':null,
                        'price_wholesaler':null,
                    }

                }
            }
        }
        catch (e) {
            $state.transitionTo('catalog.servicesproduct', null, {'reload': true});
            console.log(e);
            return false;
        }

        init();

        function init() {

            $scope.type_products = PRODUCT.TYPEPRODUCT;
            $scope.typeProductSelected = PRODUCT.TYPEPRODUCT[1];
            typeProductSelected($scope.product.type_product);

            // RESTService.all('system/typeproduct', null, function (response) {
            //     $scope.type_products = response.results;
            //     $scope.typeProductSelected = response.results[1];
            //     typeProductSelected($scope.product.type_product);
            //
            // });

            RESTService.all('warehouses/principal', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
            });

            RESTService.all('config/unitsmeasure/parents', null, function (response) {
                $scope.units = response.results;
                $scope.unitSelected = response.results[0];
                if($scope.is_edit){
                    if($scope.product.typeprice_id == $scope.is_price_general.id){
                        $scope.price_general = $scope.product.price_general;
                        unitSelected($scope.price_general.unit_id);
                    }
                }
            });

            RESTService.all('catalog/typeprice', null, function (response) {
                $scope.typeprices = response.results;
                $scope.typePriceSelected = response.results[0];
                typePriceSelected($scope.product.typeprice_id);
            });


            angular.element(document.querySelector('#product_description')).focus();

            $timeout(function () {
                $('[data-toggle="tooltip"]').tooltip();
            }, 3000);
        }


        function unitSelected(id) {
            if(!_.isUndefined(id)){
                $scope.unitSelected = ConfigPagination.searchById(id,$scope.units);
            }
        }

        function typePriceSelected(id) {
            if(!_.isUndefined(id)){
                $scope.typePriceSelected = ConfigPagination.searchById(id,$scope.typeprices);
            }
        }

        function typeProductSelected(id) {
            if(!_.isUndefined(id)){
                $scope.typeProductSelected = ConfigPagination.searchById(id,$scope.type_products);
            }
        };


        $scope.changeUnitSelected = function () {
            if($scope.typePriceSelected.id == $scope.is_price_unit.id){
            }
        };

        $scope.changeTypePriceSelected = function (item) {
            if(item.id == $scope.is_price_unit.id){
                $scope.is_edit = false;
            }
            else{
                $scope.price_general = {
                    'price_purchase':null,
                    'price_min':null,
                    'price_sale':null,
                    'price_credit':null,
                    'price_wholesaler':null,
                }
            }
        };


        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.$on("fileProgress", function(e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });

        $scope.save = function () {
            if (validate()) {
                $scope.product['type_product'] = $scope.typeProductSelected.id;
                $scope.product['typeprice_id'] = $scope.typePriceSelected.id;

                var data = {};
                data.product = $scope.product;
                data.price_general = $scope.price_general;
                data.unit_id = $scope.unitSelected.id;

                if($scope.action == 'create'){
                    RESTService.save('services/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('catalog.servicesproduct', null, {'reload': true});

                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('product/update', $scope.product.id, data, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('catalog.servicesproduct', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.product.description) || _.isEmpty($scope.product.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción del producto');
                angular.element(document.querySelector('#product_description')).focus();
                return false;
            }

            if($scope.is_price_general.id == $scope.typePriceSelected.id) {
                if (_.isNull($scope.price_general.price_sale) || _.isEmpty($scope.price_general.price_sale)) {
                    HelperFactory.show_AlertFactory('Debe ingresar el precio de venta del servicio');
                    angular.element(document.querySelector('#price_general_price_sale')).focus();
                    return false;
                }
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('catalog.servicesproduct', null, {'reload': true});
        };
    }


})();

