(function () {
    'use strict';
    angular.module('sys.app.servicesproduct')
        .controller('ServicesCtrl', ServicesCtrl);

    ServicesCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH'];

    function ServicesCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH) {

        $scope.entity = {};

        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        init();
        // sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
            RESTService.all('services/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        function sync() {
            RESTService.all('system/typeproduct', null, function (response) {
                var last = response.results.length;
                $scope.type_products = response.results;
                response.results[last] = {id: null, description:'Todos', value:null};
                $scope.typeProductSelected = response.results[last];
            });
        }

        $scope.changeTypeProduct = function (item) {
            $scope.typeProductSelected = item;
            $("#searchInput").val('');
            $scope.text = null;
            init();
        };


        $scope.searchAction = function (text) {
            $scope.text = text;
            // if (text.length >= SALE.MIN_LETTERS || text.length == 0) {
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('catalog.servicesproduct', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var source = {'id': 0};
            $state.transitionTo('catalog.servicesproduct.new', {entity: source}, {
                'reload': 'catalog.servicesproduct.new',
                'cache': false
            });
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('product/edit', source.id, function (response) {
                // response['current_page'] = $scope.page;
                // response['text'] = $scope.text;
                $state.transitionTo("catalog.servicesproduct.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "catalog.servicesproduct.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            // var source = ConfigPagination.sortDeleteid($scope.selectedItem);
            var options = {
                title: "Cuidado!!",
                message: "El producto ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('product/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('catalog.servicesproduct', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };


    }
})();

