(function () {

    'use strict';
    angular.module('sys.app.variant.new')
        .controller('NewVariantCtrl', NewVariantCtrl);

    NewVariantCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory'];

    function NewVariantCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory) {
        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.variant = $stateParams.entity;
                if ($scope.variant.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.variant.description = $scope.entity.description;
                    $scope.types = $scope.entity.types;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.variant = {
                        'description': null,
                        'comment':null
                    };
                    $scope.type_description = null;
                    $scope.types = [];
                }
            }
        }
        catch (e) {
            $state.transitionTo('catalog.variants', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {
            angular.element(document.querySelector('#variant_description')).focus();
        }

        $scope.addType = function (description) {
            if(validateDescription()){
                var item = {
                    'description': description
                }
                $scope.types.push(item);
                $scope.type_description = null;
                angular.element(document.querySelector('#type_description')).focus();
            }
        }

        function validateDescription() {
            if (_.isNull($scope.type_description) || _.isEmpty($scope.type_description)) {
                notifyAlert.warning("Debe ingresar la descripción del tipo!!");
                angular.element(document.querySelector('#type_description')).focus();
                return false;
            }
            return true;
        }


        $scope.save = function () {
            if (validate()) {

                var data = {};
                data.variant = $scope.variant;
                data.types = $scope.types;

                if($scope.action == 'create'){
                    RESTService.save('variant/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('catalog.variants', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('variant/update', $scope.variant.id, data, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('catalog.variants', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };


        function validate() {
            if (_.isNull($scope.variant.description) || _.isEmpty($scope.variant.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción de la variante');
                angular.element(document.querySelector('#variant_description')).focus();
                return false;
            }

            if ($scope.types.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un tipo de variante');
                return false;
            }

            return true;
        };

        $scope.removeType = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.types.indexOf(product);
            $scope.types.splice(index, 1);
        };

        $scope.close = function () {
            $state.transitionTo('catalog.variants', null, {'reload': true});
        };
    }

})();
