
(function () {
    'use strict';

    angular.module('sys.app.company').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];


    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider

            .state('company.informationcompany', {
                url: '/informacion',
                templateUrl: '../../templates/company/informationcompany.html',
                controller: 'InformationCompanyCtrl',
                params: {
                    entity: null
                },
                title: "Información empresa",
                module:"informationcompany"
            })

            .state('company.employees', {
                url: '/empleados',
                templateUrl: '../../templates/company/employee.html',
                controller: 'EmployeesCtrl',
                params: {
                    entity: null
                },
                title: "Empleados",
                module:"employees"
            })
            .state('company.jobs', {
                url: '/puestostrabajo',
                templateUrl: '../../templates/company/jobs.html',
                controller: 'JobsCtrl',
                params: {
                    entity: null
                },
                title: "Puestos trabajo",
                module:"jobs"
            })
            .state('company.collaborators', {
                url: '/colaboradores',
                templateUrl: '../../templates/company/collaborators.html',
                controller: 'CollaboratorsCtrl',
                params: {
                    entity: null
                },
                title: "Colaboradores",
                module:"collaborators"
            })
        ;

        $urlRouterProvider.otherwise('/empleados');
    }

})();
