(function () {
    'use strict';
    angular.module('sys.app.employees')
        .controller('EmployeesCtrl', EmployeesCtrl);

    EmployeesCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH'];

    function EmployeesCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH){

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        init();


        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
            RESTService.all('employee/list', object , function (response) {

                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('company.employees', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var client = {'id': 0}
            var source = {'data': client};
            $state.transitionTo('company.employees.new', {entity: source}, {
                'reload': 'company.employees.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            RESTService.get('employee/edit', source.id, function (response) {
                $state.transitionTo("company.employees.edit",
                    {'id': source.id,
                        entity: response
                    }, {'reload': "company.employees.edit", 'cache': false});
                delete $scope.allData;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El empleado ' "+item.fullname+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('employee/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('company.employees', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            });
        };
    }
})();




