(function () {
    'use strict';
    angular.module('sys.app.informationcompany')
        .controller('InformationCompanyCtrl', InformationCompanyCtrl);

    InformationCompanyCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', 'PRODUCT', 'EXPORT'];

    function InformationCompanyCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, PRODUCT, EXPORT) {

        init();

        function init() {
            RESTService.all('company/information', null, function (response) {
                $scope.company = response.results;
                $scope.company.url_image = $scope.company.urlImageBase;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.$on("fileProgress", function(e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });

        $scope.save = function () {
            if (validate()) {
                RESTService.updated('company/update/information', $scope.company.id, $scope.company, function (result) {
                    notifyAlert.success("Datos de la empresa actualizados con éxito!!");
                    init();
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };

        function validate() {
            return true;
        };

    }
})();



