(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendJobCtrl', ExtendJobCtrl);

    ExtendJobCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout','fileReader', 'CLIENT', 'TYPE_DOCUMENT', '$uibModal'];

    function ExtendJobCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, fileReader, CLIENT, TYPE_DOCUMENT, $uibModal) {

        var loading;

        $scope.get_param = PARAM;
        $scope.entity = $scope.get_param.entity;
        $scope.brand = $scope.entity;

        if ($scope.get_param.id != 0) {
            $scope.txt_title = 'Editar'
            $scope.action = 'edit';
            $scope.brand.description = $scope.entity.description;
        }
        else
        {
            $scope.txt_title = 'Registrar';
            $scope.action = 'create';
            $scope.brand = {
                'description': null
            };
        }

        init()

        function init() {

            $timeout(function () {
                loading = angular.element(document.querySelector('#loading_modal'));
                angular.element(document.querySelector('#brand_description')).focus();
            }, 100);
        }

        $scope.save = function () {
            if (validate()) {

                loading.show();

                if($scope.action == 'create'){
                    RESTService.save('jobs/save', $scope.brand, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        loading.hide();
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('jobs/update', $scope.brand.id, $scope.brand, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('catalog.brands', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.brand.description) || _.isEmpty($scope.brand.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción de la marca');
                angular.element(document.querySelector('#brand_description')).focus();
                return false;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
            // $uibModalInstance.dismiss('Cancelado');
            $("#loading_object").css("display","none");
        };
    }

})();
