(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendAccountBankCtrl', ExtendAccountBankCtrl);

    ExtendAccountBankCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout','fileReader', 'CLIENT', 'TYPE_DOCUMENT', '$uibModal'];

    function ExtendAccountBankCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, fileReader, CLIENT, TYPE_DOCUMENT, $uibModal) {

        var loading;

        $scope.get_param = PARAM;
        $scope.entity = $scope.get_param.entity;
        $scope.account = $scope.entity;

        if ($scope.get_param.id != 0) {
            $scope.txt_title = 'Editar'
            $scope.action = 'edit';
            $scope.account.name = $scope.entity.name;
        }
        else
        {
            $scope.txt_title = 'Registrar';
            $scope.action = 'create';
            $scope.account = {
                'name': null,
                'number_account': null,
                'cci_account': null,
                'headline': null,
                'description': null
            };
        }

        init()

        function init() {

            RESTService.all('branch/branchoffices', null, function (response) {
                $scope.branchoffices = response.results;
                $scope.branchSelected = response.results[0];

                branchSelected($scope.account.branchoffice_id);
            });

            RESTService.all('banks/search/all', null, function (response) {
                $scope.banks = response.results;
                $scope.banks_exists = false;
                if($scope.banks.length>0){
                    $scope.banks_exists = true;
                }
                listBank();
            });

            RESTService.all('finance/typeaccount', null, function (response) {
                $scope.typeaccount = response.results;
                $scope.typeAccountSelected = response.results[0];
                typeAccountSelected($scope.account.typeaccount_id);
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
                currencySelected($scope.account.currency_id);
            });

            $timeout(function () {
                loading = angular.element(document.querySelector('#loading_modal'));
                angular.element(document.querySelector('#banks_description')).focus();
            }, 100);
        };

        function listBank() {
            $timeout(function () {
                $('#bankSelected').select2();
                var last = $scope.banks.length;
                $scope.banks[last] = {id: 0, description:'Seleccione', value:0};
                $.each($scope.banks, function (i, item) {
                    $("#bankSelected").append($('<option>', {
                        value: item.id,
                        text : item.description
                    }));
                });
                $("#bankSelected").val($scope.banks[last].id);

                bankSelected($scope.account.bank_id);
            }, 100);
        };

        function bankSelected(id) {
            if(_.isUndefined(id)){
                id = null;
            }
            if(!_.isNull(id)){
                $('#bankSelected').find('option:selected').removeAttr('selected');
                $('#bankSelected').val(id);
                $('#bankSelected').change();
            }
        };


        function branchSelected(id) {
            if(!_.isUndefined(id)){
                $scope.branchSelected = ConfigPagination.searchById(id,$scope.branchoffices);
            }
        };

        function typeAccountSelected(id) {
            if(!_.isUndefined(id)){
                $scope.typeAccountSelected = ConfigPagination.searchById(id,$scope.typeaccount);
            }
        };

        function currencySelected(id) {
            if(!_.isUndefined(id)){
                $scope.currencySelected = ConfigPagination.searchById(id,$scope.currency);
            }
        };

        $scope.addBank = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/finance/banks/extends.html',
                controller: 'ExtendBankCtrl',
                size: 'sm',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var past = $scope.banks_exists;
                    $scope.banks_exists = true;
                    if(past == false){
                        $('#bankSelected').select2();
                    }
                    $timeout(function () {
                        $scope.banks_exists = true;
                        var data = result.data;
                        var last = $scope.banks.length;
                        $scope.banks[last] = data;
                        $("#bankSelected").append($('<option>', {
                            value: data.id,
                            text : data.description
                        }));
                        bankSelected(data.id);
                    }, 100);
                }
            });
        };

        $scope.save = function () {
            if (validate()) {

                loading.show();

                $scope.account['bank_id'] = $("#bankSelected").val();
                $scope.account['branchoffice_id'] = $scope.branchSelected.id;
                $scope.account['typeaccount_id'] = $scope.typeAccountSelected.id;
                $scope.account['currency_id'] = $scope.currencySelected.id;

                if($scope.action == 'create'){
                    RESTService.save('accountbanks/save', $scope.account, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        loading.hide();
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('accountbanks/update', $scope.account.id, $scope.account, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        loading.hide();
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.account.name) || _.isEmpty($scope.account.name)) {
                HelperFactory.show_AlertFactory('Debe ingresar el nombre de la cuenta');
                angular.element(document.querySelector('#account_name')).focus();
                return false;
            }

            if (_.isNull($scope.account.number_account) || _.isEmpty($scope.account.number_account)) {
                HelperFactory.show_AlertFactory('Debe ingresar el número de la cuenta');
                angular.element(document.querySelector('#account_number_account')).focus();
                return false;
            }

            if($scope.banks_exists == false){
                HelperFactory.show_AlertFactory('Debe elegir el banco asociado a la cuenta');
                angular.element(document.querySelector('#bankSelected')).focus();
                return false;
            }else{
                if ($("#bankSelected").val() == 0) {
                    HelperFactory.show_AlertFactory('Debe elegir el banco asociado a la cuenta');
                    angular.element(document.querySelector('#bankSelected')).focus();
                    return false;
                }
            }

            return true;
        };


        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
            $("#loading_object").css("display","none");
        };
    }

})();
