(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendBankCtrl', ExtendBankCtrl);

    ExtendBankCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout','fileReader', 'CLIENT', 'TYPE_DOCUMENT', '$uibModal'];

    function ExtendBankCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, fileReader, CLIENT, TYPE_DOCUMENT, $uibModal) {

        var loading;

        $scope.get_param = PARAM;
        $scope.entity = $scope.get_param.entity;
        $scope.banks = $scope.entity;

        if ($scope.get_param.id != 0) {
            $scope.txt_title = 'Editar'
            $scope.action = 'edit';
            $scope.banks.description = $scope.entity.description;
        }
        else
        {
            $scope.txt_title = 'Registrar';
            $scope.action = 'create';
            $scope.banks = {
                'description': null
            };
        }

        init()

        function init() {

            $timeout(function () {
                loading = angular.element(document.querySelector('#loading_modal'));
                angular.element(document.querySelector('#banks_description')).focus();
            }, 100);
        }

        $scope.save = function () {
            if (validate()) {

                loading.show();

                if($scope.action == 'create'){
                    RESTService.save('banks/save', $scope.banks, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        loading.hide();
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('banks/update', $scope.banks.id, $scope.banks, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('finance.banks', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.banks.description) || _.isEmpty($scope.banks.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar el nombre del banco');
                angular.element(document.querySelector('#banks_description')).focus();
                return false;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
            // $uibModalInstance.dismiss('Cancelado');
            $("#loading_object").css("display","none");
        };
    }

})();
