(function () {

    'use strict';
    angular.module('sys.app.banks.new')
        .controller('NewBankCtrl', NewBankCtrl);

    NewBankCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory'];

    function NewBankCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory) {
        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.banks = $stateParams.entity;
                if ($scope.banks.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.banks.description = $scope.entity.description;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.banks = {
                        'description': null
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('finance.banks', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {
            angular.element(document.querySelector('#banks_description')).focus();
        }

        $scope.save = function () {
            if (validate()) {
                if($scope.action == 'create'){
                    RESTService.save('banks/save', $scope.banks, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('finance.banks', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('banks/update', $scope.banks.id, $scope.banks, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('finance.banks', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.banks.description) || _.isEmpty($scope.banks.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar el nombre del banco');
                angular.element(document.querySelector('#brand_description')).focus();
                return false;
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('finance.banks', null, {'reload': true});
        };
    }

})();

