(function () {
    'use strict';
    angular.module('sys.app.movementsaccounts')
        .controller('MovementAccountBanktrl', MovementAccountBanktrl);

    MovementAccountBanktrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', 'PRODUCT', 'EXPORT', '$uibModal'];

    function MovementAccountBanktrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, PRODUCT, EXPORT, $uibModal) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        var typeprice = PRODUCT.TYPEPRICE;
        $scope.is_price_unit = typeprice[1];

        $scope.bankAccountSelected = {id: null, concat_description:'SELECCIONE CUENTA', value:null};

        init();
        sync();

        function init() {
            if($scope.bankAccountSelected.id != null){
                object = "search=" + $scope.text + '&page=' + $scope.currentPage+'&accountbank='+$scope.bankAccountSelected.id+
                "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

                RESTService.all('movements/account/list', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;

                    $scope.sum_incomes = response.sum_incomes;
                    $scope.sum_expenses = response.sum_expenses;


                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };

        function sync() {
            RESTService.all('accountbanks/search/all', null, function (response) {
                $scope.bankaccounts = response.results;
                $scope.bankaccounts_exists = false;

                var last = response.results.length;

                if($scope.bankaccounts.length > 0){
                    $scope.bankaccounts_exists = true;
                }
                $scope.bankaccounts[last] = {id: null, concat_description:'SELECCIONE CUENTA', value:null};
                $scope.bankAccountSelected = response.results[last];

            });

            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                        init();
                    }
                );
            }, 50);
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('finance.movementsaccounts', {entity: null}, {'reload': true});
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };


        $scope.changeBankAccount = function (item) {
            $scope.bankAccountSelected = item;
            $("#searchInput").val('');
            $scope.text = null;
            init();
        };

        $scope.addAccountBank = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/finance/accountbank/extends.html',
                controller: 'ExtendAccountBankCtrl',
                size: 'md',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.bankaccounts.push(data);
                    $scope.bankAccountSelected = data;
                    $scope.bankaccounts_exists = true;
                }
            });
        };
    }
})();

