(function () {

    'use strict';
    angular.module('sys.app.bedrooms.new')
        .controller('NewBedroomsCtrl', NewBedroomsCtrl);

    NewBedroomsCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory', '$timeout'];

    function NewBedroomsCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory, $timeout) {

        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.bedrooms = $stateParams.entity;

                if ($scope.bedrooms.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.bedrooms.code_number = $scope.entity.code_number;
                    $scope.bedrooms.description = $scope.entity.description;
                    $scope.bedrooms.floor = $scope.entity.floor;
                    $scope.bedrooms.observations = $scope.entity.observations;

                    $scope.ratesbedrooms = $scope.bedrooms.ratesbedrooms;

                    console.log($scope.ratesbedrooms);

                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.bedrooms = {
                        'code_number': null,
                        'description': null,
                        'floor': null,
                        'observations': null,
                    };

                    $scope.ratesbedrooms = [];
                }
            }
        }

        catch (e) {
            $state.transitionTo('hotel.bedrooms', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {
            RESTService.all('roomtypes/search/all', null, function (response) {
                $scope.roomtypes = response.results;
                $scope.roomtype_exists = false;
                if($scope.roomtypes.length>0){
                    $scope.roomtype_exists = true;
                }

                listRoomTypes();
            });

            RESTService.all('rates/search/all', null, function (response) {
                $scope.rates = response.results;
                $scope.rateSelected = response.results[0];
            });

            angular.element(document.querySelector('#bedrooms_code_number')).focus();
        }


        function listRoomTypes() {
            $timeout(function () {
                $('#roomTypeSelected').select2();
                var last = $scope.roomtypes.length;
                $scope.roomtypes[last] = {id: 0, description:'Seleccione', value:0 ,abbreviation:':'};
                $.each($scope.roomtypes, function (i, item) {
                    $("#roomTypeSelected").append($('<option>', {
                        value: item.id,
                        text : item.description + ' - ' + item.abbreviation
                    }));
                });
                $("#roomTypeSelected").val($scope.roomtypes[last].id);
                roomTypeSelected($scope.bedrooms.roomtype_id);
            }, 100);
        }

        function roomTypeSelected(id) {
            if(_.isUndefined(id)){
                id = null;
            }
            if(!_.isNull(id)){
                $('#roomTypeSelected').find('option:selected').removeAttr('selected');
                $('#roomTypeSelected').val(id);
                $('#roomTypeSelected').change();
            }
        }

        $scope.addRateBedroom = function () {
            var item = $scope.rateSelected;
            var unique = ifExistRateBedroom(item);
            if (unique) {
                item.detail_id = null;
                item.price = null;
                item.rate = item.description;

                $scope.ratesbedrooms.push(item);
            }
            else {
                notifyAlert.warning('La tarifa ' + item.description + ' ya se encuentra agregado');
            }
        }

        function ifExistRateBedroom(obj) {
            var cart = $scope.ratesbedrooms;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        };

        $scope.recalculate_price = function (price, unit, $index) {
            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();
            if (!_.isNaN(price_get * 1)) {
                var index = $scope.ratesbedrooms.indexOf(unit);
                $scope.ratesbedrooms[index].price = Number(price_get);
            }
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.removeRate = function ($event, unit, $index) {
            $event.preventDefault();
            var index = $scope.ratesbedrooms.indexOf(unit);
            $scope.ratesbedrooms.splice(index, 1);
        };

        $scope.save = function () {
            if (validate()) {
                var data = {};
                $scope.bedrooms['roomtype_id'] = $("#roomTypeSelected").val();

                data.bedrooms = $scope.bedrooms;
                data.ratesbedrooms = $scope.ratesbedrooms;

                if($scope.action == 'create'){
                    RESTService.save('bedrooms/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('hotel.bedrooms', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('bedrooms/update', $scope.bedrooms.id, data, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('hotel.bedrooms', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.bedrooms.code_number) || _.isEmpty($scope.bedrooms.code_number)) {
                HelperFactory.show_AlertFactory('Debe ingresar el nro habitacion');
                angular.element(document.querySelector('#bedrooms_code_number')).focus();
                return false;
            }

            if ($("#roomTypeSelected").val() == 0) {
                HelperFactory.show_AlertFactory('Debe seleccionar el tipo de habitación');
                angular.element(document.querySelector('#roomTypeSelected')).focus();
                return false;
            }

            if ($scope.ratesbedrooms.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos una tarifa para la habitación');
                angular.element(document.querySelector('#rateSelected')).focus();
                return false;
            }
            // check price
            for (var i in $scope.ratesbedrooms) {
                if (Number($scope.ratesbedrooms[i].price) == 0 || _.isNull($scope.ratesbedrooms[i].price)) {
                    HelperFactory.show_AlertFactory('El campo precio de la tarifa ' + $scope.ratesbedrooms[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#price' + i)).focus();
                    return false;
                }
            }
            return true;
        };

        $scope.close = function () {
            $state.transitionTo('hotel.bedrooms', null, {'reload': true});
        };
    }


})();

