(function () {
    'use strict';

    angular.module('sys.app.bookings', [
        'sys.app.bookings.new',
        'sys.app.bookings.detail'
    ]);

    angular.module('sys.app.bookings').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];

    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider

            .state('hotel.bookings.new', {
                url: '/nuevo',
                templateUrl: '../../templates/hotel/bookings/new.html',
                controller: 'NewBookingsCtrl',
                cache: false,
                params: {
                    entity: null
                },
                title: 'Crear reserva',
                module: "bookings"
            })
            
            .state('hotel.bookings.edit', {
                url: '/editar',
                templateUrl: '../../templates/hotel/bookings/new.html',
                controller: 'NewBookingsCtrl',
                cache: false,
                params: {
                    entity: null
                },
                title: 'Editar reserva',
                module: "bookings"
            })

            .state('hotel.bookings.detail', {
                url: '/detalle',
                templateUrl: '../../templates/hotel/bookings/detail.html',
                controller: 'DetailBookingsCtrl',
                params: {
                    entity: null
                },
                title:'Detalle reserva',
                module:"bookings"
            })
        ;

        $urlRouterProvider.otherwise('/reservas');
        
    }

    //endregion
})();
