(function () {
    'use strict';
    angular.module('sys.app.bookings')
        .controller('BookingsCtrl', BookingsCtrl);

    BookingsCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal'];

    function BookingsCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal) {

        $scope.entity = {};
        $scope.text = null;
        $scope.currentPage = 1;
        var object = "";

        $scope.is_all = false;

        // var start_range = moment().startOf('month');
        // var end_range = moment().endOf('month');

        var start_range = moment();
        var end_range = moment().add(1, 'days');

        $scope.start_range = start_range;
        $scope.end_range = end_range;
        $scope.is_checkout = false;

        $scope.menu_options = [{
            description: 'Reservas',
            value: 'view_bookings',
            id: 1
        }, {
            description: 'Disponibles Hoy',
            value: 'view_today',
            id: 2
        },
        {
            description: 'Res.Checkout',
            value: 'view_checkout',
            id: 3
        },
        {
            description: 'Planning',
            value: 'view_planning',
            id: 4
        }
        ];

        $scope.viewSelected = $scope.menu_options[0];
        init();
        sync();

        function init() {
            if ($scope.is_all) {
                object = "page=" + $scope.currentPage + "&is_all="+ $scope.is_all;
                RESTService.all('bookings/list', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            } else {
                object = "search=" + $scope.text + '&page=' + $scope.currentPage + "&is_checkout=" + $scope.is_checkout +
                    "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
                RESTService.all('bookings/list', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }            
        };

        
        function sync() {
            $timeout(function () {
                $('#date_range').daterangepicker({
                    locale: {
                        format: 'MMM D, YYYY'
                    },
                    startDate: $scope.start_range,
                    endDate: $scope.end_range,
                    showDropdowns: true,
                },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                        init();
                    }
                );
            }, 50);
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };


        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('hotel.bookings', { entity: null }, { 'reload': true });
        };


        $scope.export = function () {
            var obj = {
                'start_range': $scope.start_range,
                'end_range': $scope.end_range,
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/sale/export.html',
                controller: 'ExportSaleCtrl',
                size: 'modal-dialog',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                init();
            });
        };

        $scope.changeIsAll = function (item) {
            $scope.is_all = item;
            if (item) {
                $scope.start_range = null;
                $scope.end_range = null;
                angular.element(document.querySelector('#date_range')).attr("disabled", "disabled");
                angular.element(document.querySelector('#date_range')).val("");
                $scope.date_range = null;
            }

            else {
                // $scope.start_range = moment().startOf('month');
                // $scope.end_range = moment().endOf('month');
                // angular.element(document.querySelector('#date_range')).val(""); 
                // $scope.date_range = null;
                $scope.start_range = start_range;
                $scope.end_range = end_range;
                angular.element(document.querySelector('#date_range')).removeAttr("disabled");
                sync();
                // set_date($scope.start_range, $scope.end_range);                
            }

            init();
        };

        $scope.changeViewSelected = function (item) {
            $scope.viewSelected = item;
            $scope.is_checkout = false;

            var start_range = moment();
            var end_range = moment().add(1, 'days');
            if (item.value === "view_today") {
                $scope.start_range = start_range;
                $scope.end_range = end_range;
                sync();
                object = "search=" + $scope.text + '&page=' + $scope.currentPage +
                    "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
                RESTService.all('bookings/availables_bedrooms', object, function (response) {
                    console.log(response);
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
            else if (item.value === "view_planning") {
                $scope.start_range = start_range;
                $scope.end_range = end_range;
                loadPlanning();
            }
            else if (item.value === "view_checkout") {
                $scope.start_range = start_range;
                $scope.end_range = end_range;
                $scope.is_checkout = true;
                sync();
                init();
            }
            else {
                $scope.start_range = start_range;
                $scope.end_range = end_range;
                sync();
                init();
            }
        }

        $scope.planning = function () {
            $timeout(function () {
                $scope.viewSelected = $scope.menu_options[3];
                $scope.changeViewSelected($scope.menu_options[3]);
            }, 250);
        }

        function loadPlanning(is_create = true) {
            object = "start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
            RESTService.all('bookings/planning', object, function (response) {
                $scope.bedrooms = response.results;
                $scope.events_data = response.events_data;
                for (var i in $scope.events_data) {
                    $scope.events_data[i].resourceId = $scope.events_data[i].resourceid;
                }
                // var events_data = [{resourceId:1,"title":"Content booking","start":"2022-01-11","end":"2022-01-16"},{resourceId:2,"title":"Content booking","start":"2022-01-09","end":"2022-01-15"}];
                var events_data = $scope.events_data;
                if (is_create) {
                    generateCalendar($scope.bedrooms, events_data);
                } else {
                    $("#calendar").fullCalendar('removeEvents');
                    $("#calendar").fullCalendar('addEventSource', events_data);
                    $("#calendar").fullCalendar('rerenderEvents');
                }

            }, function (error) {
                console.log('ERROR');
                return false;
            });
        }

        function generateCalendar(resources_data, events_data) {
            $timeout(function () {
                $(function () {
                    // page is now ready, initialize the calendar...

                    $('#calendar').fullCalendar({
                        defaultView: 'timelineMonth',
                        initialView: 'resourceTimelineMonth',
                        initialDate: '2022-03-23',
                        header: {
                            left: 'prev,next',
                            center: 'title',
                            right: 'timelineMonth'
                        },
                        resourceLabelText: 'Habitaciones',
                        // resources: 'https://fullcalendar.io/demo-resources.json',
                        resources: resources_data,
                        // events: 'https://fullcalendar.io/demo-events.json?with-resources'
                        events: events_data,
                        eventRender: function (event, element, view) {
                            // return $('<div>' + event.title + ' es customizado</div>');
                            var class_bg = "bg-warning";
                            if (event.is_checkin) {
                                class_bg = "bg-checkin";
                            }
                            if (event.is_checkout) {
                                class_bg = "bg-checkout";
                            }
                            element.find('.fc-title').empty().append('<span class="event_data ' + class_bg + '">' + event.title + '</span> ');
                        },
                        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
                        monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                        lang: 'es',
                    })

                    $timeout(function () {
                        angular.element(document.querySelector('.fc-next-button')).click(function () {
                            $scope.start_range = $('#calendar').fullCalendar("getView").start;
                            $scope.end_range = $('#calendar').fullCalendar("getView").end;
                            loadPlanning(false);
                        });

                        angular.element(document.querySelector('.fc-prev-button')).click(function () {
                            $scope.start_range = $('#calendar').fullCalendar("getView").start;
                            $scope.end_range = $('#calendar').fullCalendar("getView").end;
                            loadPlanning(false);
                        });
                    }, 500);
                });
            }, 200);

            // $timeout(function () {

            // }, 500);
        }

        $scope.new = function () {
            var source = { 'book': { 'id': 0 }, 'is_book': true };
            $state.transitionTo('hotel.bookings.new', { entity: source }, {
                'reload': 'hotel.bookings.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.book = function (source) {
            var data = { 'book': source, 'is_book': true };

            $state.transitionTo('hotel.bookings.new', { 'id': source.id, entity: data }, {
                'reload': 'hotel.bookings.new',
                'cache': false
            });
            delete $scope.allData;

            // $state.transitionTo("booking.bookings.new", {
            //     'id': source.id,
            //     entity: source
            //
            // }, {'reload': "booking.bookings.new", 'cache': false});
            //
            // delete $scope.allData;
        };



        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('bookings/edit', source.id, function (response) {
                response.is_book = false;
                $state.transitionTo("hotel.bookings.edit", {
                    'id': source.id,
                    entity: response.data
                }, { 'reload': "hotel.bookings.edit", 'cache': false });
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.detail = function (source) {
            delete $scope.allData;
            RESTService.get('bookings/detail', source.id, function (response) {
                $state.transitionTo("hotel.bookings.detail", {
                    'id': source.id,
                    entity: response.data,
                    bedroom: source,
                }, { 'reload': "hotel.bookings.detail", 'cache': false });
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.pageChanged = function (page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' " + item.code + " ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('bookings/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = { "text": $scope.text };
                    $state.transitionTo('booking.bookings', { entity: obj }, { 'reload': true });
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            })
        };

        $scope.groupDetail = function (group_id) {
            RESTService.get('groups/detail', group_id, function (response) {
                var obj = { 'data': response.data };
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/departure/groups/modaldetail.html',
                    controller: 'ModalDetailGroupCtrl',
                    size: 'modal-dialog modal-xl',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        $scope.enableBedroom = function (bedroom) {
            RESTService.updated('bookings/enable_bedroom', bedroom.id, bedroom, function (result) {
                notifyAlert.success("Habitación N° " + bedroom.code_number + "  habilitada con éxito !");
                $timeout(function () {
                    $scope.changeViewSelected($scope.viewSelected);
                }, 200);
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.maintenanceBedroom = function (bedroom) {
            RESTService.updated('bookings/maintenance_bedroom', bedroom.id, bedroom, function (result) {
                notifyAlert.success("Habitación N° " + bedroom.code_number + " pasada a mantenimiento con éxito !");
                $timeout(function () {
                    $scope.changeViewSelected($scope.viewSelected);
                }, 200);
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };
    }
})();


