(function () {
    'use strict';

    angular.module('sys.app.bookings.detail')
        .controller('DetailBookingsCtrl', DetailBookingsCtrl);

    DetailBookingsCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert', '_', 'HelperFactory', '$timeout', 'AlertFactory', 'ConfigPagination', '$uibModal'];

    function DetailBookingsCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert, _, HelperFactory, $timeout, AlertFactory, ConfigPagination, $uibModal) {

        $scope.total_bedroom = 0;
        $scope.total_sale = 0;

        try {
            $scope.check_book = $stateParams.entity.book;

            if (!_.isNull($scope.check_book.id)) {
                $scope.entity = $stateParams.entity.book;
                $scope.book = $stateParams.entity.book;
                $scope.book_guest = $stateParams.entity.book_guest;
                $scope.book_bedroom = $stateParams.entity.book_bedroom;
                $scope.movements = $stateParams.entity.movements;
                $scope.sales = $stateParams.entity.sales;

                console.log($scope.entity);
                console.log($scope.book);

                $timeout(function () {
                    calculateTotals();
                }, 100);
            }
            
        } catch (e) {
            $state.transitionTo('hotel.bookings', null, { 'reload': true });
            console.log(e);
            return false;
        };

        function calculateTotals(){
            for (var key in $scope.sales) {
                $scope.total_sale = (Number($scope.total_sale) + Number($scope.sales[key].total)).toFixed(2);                
            }  
            
            $scope.total_bedroom = (Number($scope.book.total) - Number($scope.total_sale)).toFixed(2); 
        }

        $scope.bookingAmortization = function (booking) {
            var obj = { 'data': booking };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/hotel/bookings/modalamortization.html',
                controller: 'ModalAmortizationBookingCtrl',
                size: 'modal-dialog modal-lg modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    RESTService.get('bookings/detail', $scope.book.id, function (response) {
                        $state.transitionTo("hotel.bookings.detail", {
                            'id': $scope.book.id,
                            entity: response.data
                        }, { 'reload': "hotel.bookings.detail", 'cache': false });
                    });
                }
            }, function () {
            });
        };

        function validateCheckin() {
            // if ($scope.tours_edit.length === 0) {
            //     HelperFactory.show_AlertFactory('Para poder realizar el checkin, debe registrar por lo menos un tours al detalle de la reserva, guarde los cambios y vuelva a intentar el checkin');
            //     angular.element(document.querySelector('#search_tour_value')).focus();
            //     return false;
            // }

            return true;
        }

        $scope.checkIn = function () {
            if (validateCheckin()) {
                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de confirmar el check-in de la reserva?",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };
                AlertFactory.confirmInfo(options, function () {
                    RESTService.updated('bookings/checkin', $scope.book.id, $scope.book, function (result) {
                        notifyAlert.success("Check-in realizado con éxito !");
                        $scope.selfUpdate($scope.book.id);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        };        

        $scope.selfUpdate = function (model_id) {
            RESTService.get('bookings/detail', model_id, function (response) {
                $state.transitionTo("hotel.bookings.detail", {
                    'id': model_id,
                    entity: response.data
                }, {'reload': "hotel.bookings.detail", 'cache': false});
            });
        };

        $scope.checkOut = function () {   
            if(validateCheckin()){
                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de confirmar el check-out de la reserva? \n La habitación pasará A ESTADO DE MANTENIMIENTO",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };
                AlertFactory.confirmInfo(options, function () {
                    RESTService.updated('bookings/checkout', $scope.book.id, $scope.book_bedroom, function (result) {
                        notifyAlert.success("Check-out realizado con éxito !");
                        $scope.selfUpdate($scope.book.id);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        };     

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('bookings/edit', source.id, function (response) {
                response.is_book = false;
                $state.transitionTo("hotel.bookings.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "hotel.bookings.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.close = function () {
            $state.transitionTo('hotel.bookings', null, {'reload': true});
        };
    }

})();


