(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ModalAmortizationBookingCtrl', ModalAmortizationBookingCtrl);

    ModalAmortizationBookingCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout', 'AlertFactory', '$uibModal', 'PAYMENT_METHOD'];

    function ModalAmortizationBookingCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, AlertFactory, $uibModal, PAYMENT_METHOD) {

        var loading;

        console.log(PARAM.data);


        $scope.book = PARAM.data;
        $scope.collaborator = null;
        $scope.amount_last =  $scope.book.total - $scope.book.total_paid;
        $scope.amount_paid =  $scope.book.total_paid;
        $scope.amount = 0;
        $scope.amount_paid = 0;
        $scope.text_amount = null;
        $scope.bankaccounts_exists = false;
        $scope.bankaccounts = [];

        $scope.paymethod_deposit = PAYMENT_METHOD['deposit'];

        console.log($scope.book);

        $scope.expense = {
            'gloss': null,
            'observation': null,
            'amount': null            
        };

        init();

        function init() {

            RESTService.all('branch/listboxes', null, function (response) {
                $scope.branchboxes = response.results;
                checkBoxSelected();
            });

            RESTService.all('config/paymentmethod', null, function (response) {
                $scope.paymentmethods = response.results;
                $scope.paymentSelected = response.results[0];
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });

            $timeout(function () {
                angular.element(document.querySelector('#search_collaborator_value')).focus();
                loading = angular.element(document.querySelector('#loading_modal'));
            }, 100);
        };

        function checkBoxSelected() {
            RESTService.all('branch/checkboxselected', null, function (response) {
                $scope.checkbox = response.results;
                $scope.branchbox_id = response.branchbox_id;
                if ($scope.checkbox) {
                    boxSelected($scope.branchbox_id);
                }
                else {
                    HelperFactory.show_AlertFactory('Por favor seleccione y aperture una caja para poder realizar movimientos de dinero.');
                }
            });
        };

        function boxSelected(id) {
            if (!_.isNull(id)) {
                $scope.boxSelected = ConfigPagination.searchById(id, $scope.branchboxes);
            }
        };

        $scope.changePayment = function (item) {
            $scope.paymentSelected = item;
            if(item.id == $scope.paymethod_deposit.id){
                RESTService.all('accountbanks/search/all', null, function (response) {
                    $scope.bankaccounts = response.results;
                    $scope.bankaccounts_exists = false;
                    if($scope.bankaccounts.length>0){
                        $scope.bankaccounts_exists = true;
                        $scope.bankAccountSelected = response.results[0];
                    }
                });
            }
        };

        $scope.selectedCollaborator = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.collaborator = data.id;
                $scope.collaborator_data = data;
                angular.element(document.querySelector('#search_collaborator_value')).attr('disabled', 'disabled');
                $timeout(function () {
                    angular.element(document.querySelector('#search_collaborator_value')).val(data.fullname + ' - ' + data.document_str);
                }, 100);
            }
        };

        $scope.removeCollaborator = function () {
            angular.element(document.querySelector('#search_collaborator_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_collaborator_value')).val('');
            $scope.collaborator = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_collaborator');
        };

        $scope.addCollaborator = function (actionCreate) {
            var obj = {'id': 0};

            if (actionCreate == false) {
                obj = {
                    id: $scope.collaborator,
                    entity: $scope.edit_collaborator.data
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/collaborator/collaborators/extends.html',
                controller: 'ExtendCollaboratorCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                loading.css("display","none");
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.collaborator = data.id;
                    $scope.collaborator_data = data;
                    $timeout(function () {
                        angular.element(document.querySelector('#search_collaborator_value')).attr('disabled', 'disabled');
                        angular.element(document.querySelector('#search_collaborator_value')).val(data.fullname + ' - DOC:' + data.document);
                    }, 50);
                }
            }, function () {
                loading.css("display","none");
            });
        };

        $scope.editCollaborator = function (client_id) {
            RESTService.get('collaborators/edit', client_id, function (response) {
                $scope.edit_collaborator = response;
                $scope.addCollaborator(false);
            });
        }

        $scope.changeAmount = function (model) {
            $timeout(function () {
                calculate_difference();
            }, 300);
        };

        function calculate_difference() {
            if($scope.amount > $scope.amount_last ){
                notifyAlert.warning("El monto no puede ser mayor a la deuda total!");
                $scope.amount = 0;
            }
            else{
                $scope.amount_paid = (Number($scope.amount_last) - Number($scope.amount)).toFixed(2);
                $scope.text_amount = numero.letras($scope.amount_paid);
            }
        };

        $scope.save = function () {
            if (validate()) {
                var data = {};
                $scope.expense['currency_id'] = $scope.currencySelected.id;
                $scope.expense['paymentmethod_id'] = $scope.paymentSelected.id;
                $scope.expense['amount'] = $scope.amount;
                $scope.expense['text_amount'] = $scope.text_amount;
                $scope.expense['booking_id'] = $scope.book.id;
                $scope.expense['gloss'] = 'codigo '+ $scope.book.code + '- N° PROF:'+$scope.book.reference_voucher;
                $scope.expense['client_id'] = $scope.book.client_id;

                var accountbank_id = null;
                if($scope.bankaccounts.length > 0){
                    if($scope.paymentSelected.id == $scope.paymethod_deposit.id){
                        accountbank_id = $scope.bankAccountSelected.id;
                    }
                };

                $scope.expense['accountbank_id'] = accountbank_id ;

                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de registrar la amortización de la reserva "+$scope.book.code+" ?",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };
                AlertFactory.confirmInfo(options, function () {
                    data.income = $scope.expense;
                    RESTService.save('money/income/save/amortization_booking', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        };

        function validate() {

            if (Number($scope.amount) == 0 || _.isNull($scope.amount)) {
                HelperFactory.show_AlertFactory('El monto S/. para amortizar no puede ser igual a cero o estar vacío');
                return false;
            }

            if($scope.amount > $scope.amount_last ){
                HelperFactory.show_AlertFactory('El monto S/. a amortizar no puede ser mayor a la deuda total');
                return false;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };

        $scope.click_input_amount = function (msg, $event) {
            var el = event.target;
            el.select();
        };
    }

})();
