(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ModalCommisionBookingCtrl', ModalCommisionBookingCtrl);

    ModalCommisionBookingCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout', 'AlertFactory', '$uibModal'];

    function ModalCommisionBookingCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, AlertFactory, $uibModal) {

        var loading;

        $scope.book = PARAM.data;
        $scope.collaborator = null;
        $scope.amount = 0;
        $scope.text_amount = null;

        $scope.expense = {
            'gloss': null,
            'observation': null,
            'amount': null,
            'commision_hotel': null,
            'commision_tour': null,
        };

        init();

        function init() {

            RESTService.all('branch/listboxes', null, function (response) {
                $scope.branchboxes = response.results;
                checkBoxSelected();
            });

            RESTService.all('config/paymentmethod', null, function (response) {
                $scope.paymentmethods = response.results;
                $scope.paymentSelected = response.results[0];
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });

            $timeout(function () {
                angular.element(document.querySelector('#search_collaborator_value')).focus();
                loading = angular.element(document.querySelector('#loading_modal'));
            }, 100);
        };

        function checkBoxSelected() {
            RESTService.all('branch/checkboxselected', null, function (response) {
                $scope.checkbox = response.results;
                $scope.branchbox_id = response.branchbox_id;
                if ($scope.checkbox) {
                    boxSelected($scope.branchbox_id);
                }
                else {
                    HelperFactory.show_AlertFactory('Por favor seleccione y aperture una caja para poder realizar movimientos de dinero.');
                }
            });
        };

        function boxSelected(id) {
            if (!_.isNull(id)) {
                $scope.boxSelected = ConfigPagination.searchById(id, $scope.branchboxes);
            }
        };

        $scope.selectedCollaborator = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.collaborator = data.id;
                $scope.collaborator_data = data;
                angular.element(document.querySelector('#search_collaborator_value')).attr('disabled', 'disabled');
                $timeout(function () {
                    angular.element(document.querySelector('#search_collaborator_value')).val(data.fullname + ' - ' + data.document_str);
                }, 100);
            }
        };

        $scope.removeCollaborator = function () {
            angular.element(document.querySelector('#search_collaborator_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_collaborator_value')).val('');
            $scope.collaborator = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_collaborator');
        };

        $scope.addCollaborator = function (actionCreate) {
            var obj = {'id': 0};

            if (actionCreate == false) {
                obj = {
                    id: $scope.collaborator,
                    entity: $scope.edit_collaborator.data
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/collaborator/collaborators/extends.html',
                controller: 'ExtendCollaboratorCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                loading.css("display","none");
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.collaborator = data.id;
                    $scope.collaborator_data = data;
                    $timeout(function () {
                        angular.element(document.querySelector('#search_collaborator_value')).attr('disabled', 'disabled');
                        angular.element(document.querySelector('#search_collaborator_value')).val(data.fullname + ' - DOC:' + data.document);
                    }, 50);
                }
            }, function () {
                loading.css("display","none");
            });
        };

        $scope.editCollaborator = function (client_id) {
            RESTService.get('collaborators/edit', client_id, function (response) {
                $scope.edit_collaborator = response;
                $scope.addCollaborator(false);
            });
        }

        $scope.changeCommisionHotel = function (model) {
            $timeout(function () {
                sum_items();
            }, 200);
        };

        $scope.changeCommisionTour = function (model) {
            $timeout(function () {
                sum_items();
            }, 200);
        };


        function sum_items() {
            $scope.amount = (Number($scope.expense.commision_hotel) + Number($scope.expense.commision_tour)).toFixed(2);
            $scope.text_amount = numero.letras($scope.amount);
        };

        $scope.save = function () {
            if (validate()) {
                var data = {};
                $scope.expense['currency_id'] = $scope.currencySelected.id;
                $scope.expense['paymentmethod_id'] = $scope.paymentSelected.id;
                $scope.expense['collaborator_id'] = $scope.collaborator;
                $scope.expense['total_hotel'] = $scope.expense.commision_hotel;
                $scope.expense['total_tour'] = $scope.expense.commision_tour;
                $scope.expense['amount'] = $scope.amount;
                $scope.expense['text_amount'] = $scope.text_amount;
                $scope.expense['booking_id'] = $scope.book.id;
                $scope.expense['gloss'] = 'entregado a '+ $scope.collaborator_data.fullname+ ' - N° PROF: ' +$scope.book.reference_voucher;

                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de registrar la comisión?",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };
                AlertFactory.confirmInfo(options, function () {
                    data.expense = $scope.expense;

                    RESTService.save('money/expense/save/commision', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $uibModalInstance.close(result);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        };

        function validate() {
            if (_.isNull($scope.collaborator) || _.isUndefined($scope.collaborator)) {
                HelperFactory.show_AlertFactory('Debe seleccionar el colaborador que va recibir la comisión.');
                angular.element(document.querySelector('#search_collaborator_value')).focus();
                return false;
            }

            if (Number($scope.amount) == 0 || _.isNull($scope.amount)) {
                HelperFactory.show_AlertFactory('El total S/. a comisionar no puede ser igual a cero o estar vacío');
                return false;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };

        $scope.click_input_amount = function (msg, $event) {
            var el = event.target;
            el.select();
        };
    }

})();

