(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ModalDetailBookingCtrl', ModalDetailBookingCtrl);

    ModalDetailBookingCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout', 'VOUCHER', 'TOURISM', '$uibModal', 'AlertFactory'];

    function ModalDetailBookingCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, VOUCHER, TOURISM, $uibModal, AlertFactory) {

        var loading;

        var data = PARAM.data;

        $scope.book = data.book;
        $scope.tours = data.tours;
        $scope.hotels = data.hotels;
        $scope.movements = data.movements;
        $scope.commisions = data.commisions;
        $scope.arrivalplaces = TOURISM.ARRIVAL_PLACES;
        $scope.arrivalPlaceSelected = TOURISM.ARRIVAL_PLACES[0];
        $timeout(function () {
            arrivalPlaceSelected($scope.book.arrivalplace_id);

            loading = angular.element(document.querySelector('#loading_modal'));
        }, 100);


        function arrivalPlaceSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.arrivalPlaceSelected = ConfigPagination.searchById(id, $scope.arrivalplaces);
            }
        };


        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };

        $scope.printer = function () {
            $('#body').printThis({
                importCSS: true,
            });
        }

        $scope.bookingCommision = function (booking) {
            var obj = { 'data': booking };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/booking/bookings/modalcommision.html',
                controller: 'ModalCommisionBookingCtrl',
                size: 'modal-dialog modal-lg modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                loading.css("display", "none");
                if (!_.isUndefined(result)) {
                    $uibModalInstance.close(result);
                }
            }, function () {
                loading.css("display", "none");
            });
        };

        $scope.bookingAmortization = function (booking) {
            var obj = { 'data': booking };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/booking/bookings/modalamortization.html',
                controller: 'ModalAmortizationBookingCtrl',
                size: 'modal-dialog modal-lg modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                loading.css("display", "none");
                if (!_.isUndefined(result)) {
                    $uibModalInstance.close(result);
                }
            }, function () {
                loading.css("display", "none");
            });
        };

        $scope.checkOut = function () {
            var options = {
                title: "¡Atención!",
                message: "¿Esta seguro(a) de confirmar el check-out de la reserva?",
                cancel: "Cancelar",
                confirm: "Confirmar"
            };
            AlertFactory.confirmInfo(options, function () {
                RESTService.updated('bookings/checkout', $scope.book.id, $scope.book, function (result) {
                    notifyAlert.success("Check-out realizado con éxito !");
                    $state.transitionTo('booking.board', null, { 'reload': true });
                });
            });
        };

        $scope.groupDetail = function (group_id) {
            RESTService.get('groups/detail', group_id, function (response) {
                var obj = { 'data': response.data };
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/departure/groups/modaldetail.html',
                    controller: 'ModalDetailGroupCtrl',
                    size: 'modal-dialog modal-xl',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        
        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('bookings/edit', source.id, function (response) {
                $uibModalInstance.close(response);
                $state.transitionTo("booking.bookings.edit", {
                    'id': source.id,
                    entity: response.data
                }, { 'reload': "booking.bookings.edit", 'cache': false });
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };
    }

})();
