(function () {

    'use strict';
    angular.module('sys.app.bookings.new')
        .controller('NewBookingsCtrl', NewBookingsCtrl);

    NewBookingsCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', '$timeout', 'fileReader', 'CLIENT', 'TOURISM', '$uibModal', 'AlertFactory', 'TYPE_DOCUMENT'];

    function NewBookingsCtrl($scope, $stateParams, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, $timeout, fileReader, CLIENT, TOURISM, $uibModal, AlertFactory, TYPE_DOCUMENT) {

        // $scope.tours = [];
        // $scope.hotels = [];
        // $scope.flights = [];
        // $scope.catalogs = [];

        // $scope.total_tours = 0;
        // $scope.total_hotels = 0;
        // $scope.total_flights = 0;
        // $scope.total_catalogs = 0;
        // $scope.total_book = 0;
        $scope.client = null;
        $scope.is_edit = false;

        $scope.bedroom_id = null;
        $scope.is_bedroom_selected = false;
        $scope.subtotal_bedroom = 0;
        $scope.subtotal_order = 0;
        $scope.is_available = true;

        $scope.total_book = 0;

        $scope.book_guest = [];

        try {
            $scope.check_book = $stateParams.entity.book;

            if (!_.isNull($scope.check_book.id)) {
                $scope.data_edit = $stateParams.entity;
                // $scope.entity = $stateParams.entity.book;

                RESTService.all('bedrooms/search/all', null, function (response) {
                    $scope.bedrooms = response.results;
                    $scope.bedrooms_exists = false;
                    if ($scope.bedrooms.length > 0) {
                        $scope.bedrooms_exists = true;
                    }

                    listBedrooms();
                });

                if ($scope.data_edit.is_book === true) {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.book = {
                        'tel_1': null,
                        'tel_2': null,
                        'nro_pax': null,
                        'date_checkin': null,
                        'reference_voucher': null,
                        'observations': null,
                        'arrival_place': null,
                        'reference_location': null,
                        'contact_emergency': null,
                        'telephone_emergency': null,
                        'is_detail_subtotaltour': false,
                        'register_flight': null,
                    };


                    $scope.book_bedroom = {
                        'bedroom_id': null,
                        'roomtype_id': null,
                        'code_number': null,
                        'roomtype': null,
                        'rate': null,
                        'date_checkin': null,
                        'date_checkout': null,
                        'time_checkin': "13:00",
                        'time_checkout': "12:00",
                        'number_nights': null,
                        'number_adults': null,
                        'number_kids': null,
                        'number_towells': null,
                    };

                } else {
                    $scope.txt_title = 'Editar';
                    $scope.action = 'edit';
                    $scope.is_edit = true;

                    $scope.data_book = $scope.data_edit.book;
                    $scope.data_book_bedroom = $scope.data_edit.book_bedroom;
                    $scope.book_guest = $scope.data_edit.book_guest;

                    $scope.book = $scope.data_book;

                    // $scope.book = {
                    //     'code': $scope.data_book.code,
                    //     'arrival_place': $scope.data_book.arrival_place,
                    //     'reference_location': null,
                    //     'observations': null,
                    //     'contact_emergency': null,
                    //     'telephone_emergency': null,
                    // };

                    $scope.bedroom_id = $scope.data_book_bedroom.bedroom_id;
                    $scope.book_bedroom = {
                        'bedroom_id': $scope.data_book_bedroom.bedroom_id,
                        'roomtype_id': $scope.data_book_bedroom.roomtype_id,
                        'rate': $scope.data_book_bedroom.rate,
                        'date_checkin': moment($scope.data_book_bedroom.date_checkin).format('YYYY-MM-DD'),
                        'date_checkout': moment($scope.data_book_bedroom.date_checkout).format('YYYY-MM-DD'),
                        'time_checkin': "13:00",
                        'time_checkout': "12:00",
                        'number_nights': $scope.data_book_bedroom.number_nights,
                        'number_adults': $scope.data_book_bedroom.number_adults,
                        'number_kids': $scope.data_book_bedroom.number_kids,
                        'number_towells': $scope.data_book_bedroom.number_towells,
                    };

                    angular.element(document.querySelector('#date_checkin')).val(moment($scope.data_book_bedroom.date_checkin).format('YYYY-MM-DD'));
                    angular.element(document.querySelector('#date_checkout')).val(moment($scope.data_book_bedroom.date_checkout).format('YYYY-MM-DD'));


                    // $scope.book.tel_1 = $scope.book.client_data.cellphone;
                    // $scope.book.tel_2 = $scope.book.client_data.telephone;
                    //
                    // $scope.tours = $stateParams.entity.tours;
                    // $scope.tours_edit = $stateParams.entity.tours;
                    //
                    // $scope.hotels = $stateParams.entity.hotels;
                    // $scope.hotels_edit = $stateParams.entity.hotels;

                    // clientSelected($scope.book);
                }
            }
        } catch (e) {
            $state.transitionTo('hotel.bookings', null, {'reload': true});
            console.log(e);
            return false;
        }
        ;


        sync();

        function sync() {

            $scope.originsbooking = TOURISM.ORIGIN_BOOKIN;
            $scope.originBookingSelected = TOURISM.ORIGIN_BOOKIN[0];

            $scope.arrivalplaces = TOURISM.ARRIVAL_PLACES;
            $scope.arrivalPlaceSelected = TOURISM.ARRIVAL_PLACES[0];

            $timeout(function () {

                // RESTService.all('roomtypes/search/all', null, function (response) {
                //     $scope.roomtypes = response.results;
                //     roomTypeSelected($scope.book_bedroom.roomtype_id);
                // });

                $('#date_checkin').daterangepicker({
                        locale: {
                            format: 'YYYY-MM-DD'
                        },
                        singleDatePicker: true,
                        showDropdowns: true,
                        minDate: moment()
                    }, function (start, end, label) {

                        $('#date_checkout').data('daterangepicker').minDate = moment(start).add(1, 'days');
                        angular.element(document.querySelector('#date_checkin')).val(moment(start).format('YYYY-MM-DD'));
                        angular.element(document.querySelector('#date_checkout')).val(moment(start).add(1, 'days').format('YYYY-MM-DD'));
                        $scope.book_bedroom.date_checkin = moment(start).format('YYYY-MM-DD');
                        $scope.book_bedroom.date_checkout = moment(start).add(1, 'days').format('YYYY-MM-DD');

                        calculateNumberNights()
                    }
                );

                $('#date_checkout').daterangepicker({
                        locale: {
                            format: 'YYYY-MM-DD'
                        },
                        singleDatePicker: true,
                        showDropdowns: true,
                        minDate: moment().add(1, 'days')
                    }, function (start, end, label) {

                        angular.element(document.querySelector('#date_checkout')).val(moment(start).format('YYYY-MM-DD'));
                        $scope.book_bedroom.date_checkout = moment(start).format('YYYY-MM-DD');

                        calculateNumberNights();
                    }
                );

                angular.element(document.querySelector('#time_checkin')).val($scope.book_bedroom.time_checkin);
                angular.element(document.querySelector('#time_checkout')).val($scope.book_bedroom.time_checkout);
                calculateNumberNights();

                angular.element(document.querySelector('#search_client_value')).focus();

                if ($scope.is_edit) {

                    originBookingSelected($scope.book.bookingorigin_id);
                    arrivalPlaceSelected($scope.book.arrivalplace_id);

                    $timeout(function () {
                        $scope.total_tours = $scope.book.subtotal_tour;
                        $scope.total_hotels = $scope.book.subtotal_hotel;
                        $scope.total_flights = $scope.book.subtotal_flight;
                        $scope.total_catalogs = $scope.book.subtotal_catalog;
                        $scope.total = $scope.book.total;

                        sum_items();
                    }, 100);
                }
            }, 50);
        };


        function roomTypeSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.roomTypeSelected = ConfigPagination.searchById(id, $scope.roomtypes);
            }
        };

        function listBedrooms() {
            $timeout(function () {
                $('#bedroomSelected').select2();
                var last = $scope.bedrooms.length;
                $scope.bedrooms[last] = {
                    id: 0,
                    text: 'Seleccione',
                    code_number: 'Seleccione',
                    value: 0,
                    roomtype: {abbreviation: '-'}
                };
                $.each($scope.bedrooms, function (i, item) {
                    $("#bedroomSelected").append($('<option>', {
                        value: item.id,
                        text: item.code_number + ' - ' + item.roomtype.abbreviation
                    }));
                });

                $("#bedroomSelected").val($scope.bedrooms[last].id);
                bedroomSelected($scope.bedroom_id);
            }, 100);
        }

        function bedroomSelected(id) {
            if (_.isUndefined(id)) {
                id = null;
            }
            if (!_.isNull(id)) {
                $('#bedroomSelected').find('option:selected').removeAttr('selected');
                $('#bedroomSelected').val(id);
                $('#bedroomSelected').change();
            }
        }

        $scope.changebedroomSelected = function () {        
            var val_bedroom_id = $('#bedroomSelected').val();
            $scope.is_available = true;
            if (val_bedroom_id !== 0 || val_bedroom_id !== null) {
                $scope.bedroom_id = val_bedroom_id;
                $scope.is_bedroom_selected = true;
                $scope.bedroomSelected = ConfigPagination.searchById(val_bedroom_id, $scope.bedrooms);

                console.log($scope.bedroomSelected);

                listRoomTypes($scope.bedroomSelected.roomtype_id);

                $scope.ratesbedrooms = $scope.bedroomSelected.ratesbedrooms;
                $scope.rateSelected = $scope.bedroomSelected.ratesbedrooms[0];
                $scope.price_hotel = $scope.bedroomSelected.ratesbedrooms[0].price;
                $timeout(function () {
                    sum_items();
                }, 50);

            } else {
                $scope.is_bedroom_selected = false;
            }

        }

        function listRoomTypes(roomtype_id) {
            RESTService.all('roomtypes/search/all', null, function (response) {
                $scope.roomtypes = response.results;
                roomTypeSelected(roomtype_id);
            });
        }

        $scope.changeRoomType = function (item) {
            $scope.roomTypeSelected = item;
        }

        $scope.changeRateBedroom = function (item) {
            $scope.rateSelected = item;
            $scope.price_hotel = item.price;
            $timeout(function () {
                sum_items();
            }, 50);
        }

        function calculateNumberNights() {
            var date_checkout = moment($("#date_checkout").val(), 'YYYY-MM-DD');
            var date_checkin = moment($("#date_checkin").val(), 'YYYY-MM-DD');
            $scope.book_bedroom.number_nights = date_checkout.diff(date_checkin, 'days');
            if($scope.is_bedroom_selected){
                sum_items();
            }
        }

        function clientSelected(data) {
            $scope.client = data.client_id;
            $timeout(function () {
                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                $timeout(function () {
                    angular.element(document.querySelector('#search_client_value')).val(data.client_data.fullname + ' - ' + data.client_data.typeDocument + ':' + data.client_data.document);
                }, 100);
            }, 100);
        };

        function originBookingSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.originBookingSelected = ConfigPagination.searchById(id, $scope.originsbooking);
            }
        };

        function arrivalPlaceSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.arrivalPlaceSelected = ConfigPagination.searchById(id, $scope.arrivalplaces);
            }
        };

        // TOUR DATA ===========

        $scope.selectedTour = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;
                var unique = ifExistTour(item);
                if (unique) {
                    item.quantity = null;
                    item.date_realized = null;
                    item.observation = null;
                    item.price = null;
                    item.subtotal = 0;
                    // item.price_public = null;
                    // item.price_corporate = null;

                    if ($scope.book.is_detail_subtotaltour) {
                        item.price = item.price_public;
                    }
                    ;

                    $scope.tours.push(item);

                    $timeout(function () {
                        // set values initialas
                        initialDateAssigned(item);
                        initialVehicleTour(item);
                        initialShiftTour(item);

                    }, 50);
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_tour');
                    angular.element(document.querySelector('#search_tour_value')).focus();
                } else {
                    notifyAlert.warning('El tours ' + item.description + ' ya se encuentra agregado');
                }
            }
        };



        function ifExistTour(obj) {
            var cart = $scope.tours;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        };

        function initialDateAssigned(item) {
            var index = $scope.tours.indexOf(item);
            $scope.tours[index].date_assigned = null;
            $('#date_assigned' + index).daterangepicker({
                singleDatePicker: true,
                autoUpdateInput: false,
                showDropdowns: true,
                minDate: new Date(),
                locale: {
                    format: 'YYYY-MM-DD'
                }
            }, function (chosen_date) {
                $(this.element[0]).val(chosen_date.format('YYYY-MM-DD'));
                var check_index = $scope.tours.indexOf(item);
                $scope.tours[check_index].date_assigned = chosen_date.format('YYYY-MM-DD');
            });

        };

        function initialVehicleTour(tour) {
            var index = $scope.tours.indexOf(tour);
            var options = TOURISM.VEHICLE_TOURS;

            $("#vehicleTourSelected" + index).html('');

            $.each(options, function (i, item) {
                $("#vehicleTourSelected" + index).append($('<option>', {
                    value: item.id,
                    text: item.description
                }));
            });
            $("#vehicleTourSelected" + index).val(options[0].id);

            $scope.tours[index].vehicle_tour = options[0].id;
        };

        function initialShiftTour(tour) {
            var index = $scope.tours.indexOf(tour);
            var options = TOURISM.SHIFT_TOURS;

            $("#shiftTourSelected" + index).html('');

            $.each(options, function (i, item) {
                $("#shiftTourSelected" + index).append($('<option>', {
                    value: item.id,
                    text: item.description
                }));
            });
            $("#shiftTourSelected" + index).val(tour.shift);
            $scope.tours[index].shift_tour = options[0].id;
        };

        $scope.changeVehicleTour = function (model, tour, $index) {
            var check_option = angular.element(document.querySelector('#vehicleTourSelected' + $index)).val();
            var pos = $scope.tours.indexOf(tour);
            $scope.tours[pos].vehicle_tour = check_option;
        };

        $scope.changeShiftTour = function (model, tour, $index) {
            var check_option = angular.element(document.querySelector('#shiftTourSelected' + $index)).val();
            var pos = $scope.tours.indexOf(tour);
            $scope.tours[pos].shift_tour = check_option;
        };

        $scope.changeToursObservation = function (model, tour, $index) {
            var check_option = angular.element(document.querySelector('#tours_observation' + $index)).val();
            var pos = $scope.tours.indexOf(tour);
            $scope.tours[pos].observation = check_option;
        };

        $scope.changeToursQuantity = function (model, tour, $index) {
            var check_quantity = angular.element(document.querySelector('#tours_quantity' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#tours_quantity' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#tours_quantity' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.tours.indexOf(tour);
                $scope.tours[index].quantity = quantity;

                if ($scope.book.is_detail_subtotaltour) {
                    $timeout(function () {
                        sum_items();
                    }, 300);
                }
            }
        };

        // HOTEL DATA ==========

        $scope.selectedHotel = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;
                var unique = ifExistHotel(item);
                if (unique) {
                    item.date_checkin = null;
                    item.date_checkout = null;
                    item.observation = null;
                    item.quantity = null;
                    item.price = null;
                    item.nights = null;
                    item.rooms = null;
                    item.subtotal = 0;

                    $scope.hotels.push(item);

                    $timeout(function () {
                        // set values initialas
                        initialDateCheckin(item);
                        initialDateCheckout(item);
                    }, 50);
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_hotel');
                    angular.element(document.querySelector('#search_hotel_value')).focus();
                } else {
                    notifyAlert.warning('El hotel ' + item.tradename + ' ya se encuentra agregado');
                }
            }
        };

        $scope.removeHotel = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.hotels.indexOf(product);
            $scope.hotels.splice(index, 1)
            $timeout(function () {
                sum_items();
            }, 300);
            notifyAlert.info("El hotel " + product.tradename + ' ha sido removido');
        };

        function ifExistHotel(obj) {
            var cart = $scope.hotels;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        };

        function initialDateCheckin(item) {
            var index = $scope.hotels.indexOf(item);
            $scope.hotels[index].date_checkin = null;
            $('#date_checkin' + index).daterangepicker({
                singleDatePicker: true,
                autoUpdateInput: false,
                showDropdowns: true,
                locale: {
                    format: 'YYYY-MM-DD'
                }
            }, function (chosen_date) {
                $(this.element[0]).val(chosen_date.format('YYYY-MM-DD'));
                var check_index = $scope.hotels.indexOf(item);
                $scope.hotels[check_index].date_checkin = chosen_date.format('YYYY-MM-DD');
            });
        };

        function initialDateCheckout(item) {
            var index = $scope.hotels.indexOf(item);
            $scope.hotels[index].date_checkout = null;
            $('#date_checkout' + index).daterangepicker({
                singleDatePicker: true,
                autoUpdateInput: false,
                showDropdowns: true,
                locale: {
                    format: 'YYYY-MM-DD'
                }
            }, function (chosen_date) {
                $(this.element[0]).val(chosen_date.format('YYYY-MM-DD'));
                var check_index = $scope.hotels.indexOf(item);
                $scope.hotels[check_index].date_checkout = chosen_date.format('YYYY-MM-DD');
            });
        };

        $scope.changeHotelsQuantity = function (model, tour, $index) {
            var check_quantity = angular.element(document.querySelector('#hotels_quantity' + $index)).val();
            var q_ = check_quantity;
            angular.element(document.querySelector('#hotels_quantity' + $index)).val(q_);
            var quantity = angular.element(document.querySelector('#hotels_quantity' + $index)).val();
            if (!_.isNaN(quantity * 1)) {
                var index = $scope.hotels.indexOf(tour);
                $scope.hotels[index].quantity = quantity;
            }
        };

        $scope.changeHotelsRooms = function (model, tour, $index) {
            var check_quantity = angular.element(document.querySelector('#hotels_rooms' + $index)).val();
            var q_ = check_quantity;
            angular.element(document.querySelector('#hotels_rooms' + $index)).val(q_);
            var quantity = angular.element(document.querySelector('#hotels_rooms' + $index)).val();
            if (!_.isNaN(quantity * 1)) {
                var index = $scope.hotels.indexOf(tour);
                $scope.hotels[index].rooms = quantity;
            }
        };

        $scope.changeHotelsNights = function (model, tour, $index) {
            var check_quantity = angular.element(document.querySelector('#hotels_nights' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#hotels_nights' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#hotels_nights' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.hotels.indexOf(tour);
                $scope.hotels[index].nights = quantity;
                $scope.hotels[index].subtotal = (Number(tour.price) * Number(quantity)).toFixed(2);

                $timeout(function () {
                    sum_hotels();
                }, 300);
            }
        };

        $scope.changeHotelsPrice = function (model, tour, $index) {
            var check_quantity = angular.element(document.querySelector('#hotels_price' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#hotels_price' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#hotels_price' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.hotels.indexOf(tour);

                $scope.hotels[index].price = quantity;
                $scope.hotels[index].subtotal = (Number(tour.nights) * Number(quantity)).toFixed(2);
                $timeout(function () {
                    sum_hotels();
                }, 300);
            }
        };

        $scope.changeHotelsObservation = function (model, tour, $index) {
            var check_option = angular.element(document.querySelector('#hotels_observation' + $index)).val();
            var pos = $scope.hotels.indexOf(tour);
            $scope.hotels[pos].observation = check_option;
        };

        function sum_hotels() {
            $scope.total_hotels = 0;
            for (var i in $scope.hotels) {
                var item = $scope.hotels[i];
                $scope.total_hotels = (Number($scope.total_hotels) + (Number(item.price) * Number(item.nights))).toFixed(2);
            }

            $timeout(function () {
                sum_items();
            }, 300);
        };


        // FLIGHTS DATA ==========

        $scope.selectedAirline = function (response) {

            var item = response.originalObject;

            item.flight_number = null;
            item.quantity_adults = null;
            item.quantity_infants = null;
            item.origin = null;
            item.destiny = null;
            item.dateflight_arrival = null;
            item.observation = null;

            $scope.flights.push(item);

            $timeout(function () {
                // set values initialas
                initialTypeFlight(item);
                initialDateFlight(item);
            }, 50);

        };

        $scope.removeAirline = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.flights.indexOf(product);
            $scope.flights.splice(index, 1)
            $timeout(function () {
                sum_items();
            }, 300);
            notifyAlert.info("El vuelo de " + product.description + ' ha sido removido');
        };

        function initialTypeFlight(tour) {
            var index = $scope.flights.indexOf(tour);
            var options = TOURISM.TYPE_FLIGHT;

            $("#typeFlightSelected" + index).html('');
            $.each(options, function (i, item) {
                $("#typeFlightSelected" + index).append($('<option>', {
                    value: item.id,
                    text: item.description
                }));
            });
            $("#typeFlightSelected" + index).val(options[0].id);
            $scope.flights[index].type_flight = options[0].id;
        };

        function initialDateFlight(item) {
            var index = $scope.flights.indexOf(item);
            $scope.flights[index].dateflight_arrival = null;
            $('#flights_dateflight_arrival' + index).daterangepicker({
                singleDatePicker: true,
                autoUpdateInput: false,
                showDropdowns: true,
                minDate: new Date(),
                locale: {
                    format: 'YYYY-MM-DD'
                }
            }, function (chosen_date) {
                $(this.element[0]).val(chosen_date.format('YYYY-MM-DD'));
                var check_index = $scope.flights.indexOf(item);
                $scope.flights[check_index].dateflight_arrival = chosen_date.format('YYYY-MM-DD');
            });
        };

        $scope.changeTypeFlight = function (model, tour, $index) {
            var check_option = angular.element(document.querySelector('#typeFlightSelected' + $index)).val();
            var pos = $scope.flights.indexOf(tour);
            $scope.flights[pos].type_flight = check_option;
        };

        function sum_items() {
            $scope.total_book = 0;
            $scope.subtotal_bedroom = Number($scope.price_hotel) * Number($scope.book_bedroom.number_nights);
            $scope.total_book = (Number($scope.subtotal_bedroom) + Number($scope.subtotal_order)).toFixed(2);
            $scope.text_amount = numero.letras($scope.total_book);
        };

        $scope.changeTotalHotel = function (price_hotel) {
            $scope.price_hotel = price_hotel;
            $timeout(function () {
                sum_items();
            }, 200);
        };

        $scope.changeTotalFlights = function (total) {
            $scope.total_flights = total;
            $timeout(function () {
                sum_items();
            }, 200);
        };


        $scope.saveBook = function () {
            if (validate()) {

                var object = "bedroom_id=" + $scope.bedroom_id + '&start_range=' + $scope.book_bedroom.date_checkin + '&end_range=' + $scope.book_bedroom.date_checkout
                    + '&is_edit=' + $scope.is_edit + '&booking_id=' + $scope.book.id;
                RESTService.all('bookings/bedroom/available', object, function (response) {
                    $scope.total_overbookings = response.total;
                    if (response.total === 0) {

                        var data = {};
                        // $scope.book['client_id'] = $scope.client;
                        // $scope.book['time_arrival'] = $("#time_arrival").val();
                        $scope.book['bookingorigin_id'] = $scope.originBookingSelected.id;
                        $scope.book['arrivalplace_id'] = $scope.arrivalPlaceSelected.id;
                        $scope.book['total'] = $scope.total_book;
                        $scope.book['text_amount'] = $scope.text_amount;
    
    
                        // $scope.book['subtotal_tour'] = $scope.total_tours;
                        // $scope.book['subtotal_hotel'] = $scope.total_hotels;
                        // $scope.book['subtotal_flight'] = $scope.total_flights;
                        // $scope.book['text_amount'] = $scope.text_amount;
                        // $scope.book['total'] = $scope.total_book;
    
                        $scope.book_bedroom['bedroom_id'] = $scope.bedroom_id;
                        $scope.book_bedroom['roomtype_id'] = $scope.roomTypeSelected.id;
                        $scope.book_bedroom['rate'] = $scope.rateSelected.price;
                        $scope.book_bedroom['ratebedroom_id'] = $scope.rateSelected.id;
    
                        data.book = $scope.book;
                        data.book_bedroom = $scope.book_bedroom;
                        data.book_guest = $scope.book_guest;
                        // data.flights = $scope.flights;
                        
    
                        if ($scope.action == 'create') {
                            RESTService.save('bookings/save', data, function (result) {
                                notifyAlert.success("Registro realizado con éxito!!");
                                $state.transitionTo('hotel.bookings', null, {'reload': true});
                                // RESTService.get('bookings/detail', result.data.id, function (response) {
                                //     $state.transitionTo("booking.bookings.detail", {
                                //         'id': result.data.id,
                                //         entity: response.data
                                //     }, {'reload': "hotel.bookings.detail", 'cache': false});
                                // });
                            }, function (error) {
                                console.log('ERROR');
                                return false;
                            });
                        } else if ($scope.action == 'edit') {
                            RESTService.updated('bookings/update', $scope.book.id, data, function (result) {
                                notifyAlert.success("Registro actualizado con éxito!!");
                                $state.transitionTo('hotel.bookings', null, {'reload': true});
                            }, function (error) {
                                console.log('ERROR');
                                return false;
                            });
                        }
                    }
                    else {
                        $scope.is_available = false;
                        $scope.over_bookings = response.results;
                        swal({
                            type: 'warning',
                            title: 'Advertencia !!',
                            html: "Se encontró " + response.total + " reservas para la HABITACIÓN N° (" + $scope.bedroomSelected.code_number + ") en las fechas seleccionadas."
                        })
                        return false;
                    }

                });

            }
        };

        function validate() {
            if (_.isNull($scope.bedroom_id) || $scope.bedroom_id === 0) {
                HelperFactory.show_AlertFactory('Debe seleccionar la habitación para la reserva');
                angular.element(document.querySelector('#bedroomSelected')).focus();
                return false;
            }
            if($scope.bedroomSelected.is_dirty){
                HelperFactory.show_AlertFactory('La Habitación seleccionada se encuentra en estado de MANTENIMENTO');
                angular.element(document.querySelector('#bedroomSelected')).focus();
                return false;
            }

            // if (!$scope.is_available) {
            //     HelperFactory.show_AlertFactory('La habitación registra reservas para las fechas seleccionadas (posible OVERBOOKING), verifique para poder continuar.');
            //     angular.element(document.querySelector('#available_bedroom_btn')).focus();
            //     return false;
            // }                        
            if ($scope.book_guest.length === 0) {
                HelperFactory.show_AlertFactory('Debe registrar al menos 1 pasajero responsable para la reserva');
                return false;
            }

            if (Number($scope.price_hotel) === 0 || _.isNull($scope.price_hotel)) {
                HelperFactory.show_AlertFactory('El precio de la habitación no puede estar vacío o estar igual a cero.');
                angular.element(document.querySelector('#rate')).focus();
                return false;
            }

            if (Number($scope.book_bedroom.number_nights) === 0 || _.isNull($scope.book_bedroom.number_nights)) {
                HelperFactory.show_AlertFactory('El N° noches del hotel no puede estar vacío o ser igual a cero.');
                angular.element(document.querySelector('#number_nights')).focus();
                return false;
            }

            return true;

            if (_.isNull($scope.book.date_arrival)) {
                HelperFactory.show_AlertFactory('Debe ingresar la fecha de llegada');
                angular.element(document.querySelector('#date_arrival')).focus();
                return false;
            }


            // check tours valur
            for (var i in $scope.tours) {
                if (Number($scope.tours[i].quantity) == 0 || _.isNull($scope.tours[i].quantity)) {
                    HelperFactory.show_AlertFactory('El N° pax para el tours ' + $scope.tours[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#tours_quantity' + i)).focus();
                    return false;
                }

                if (_.isNull($scope.tours[i].date_assigned)) {
                    HelperFactory.show_AlertFactory('La fecha asignada para el tours ' + $scope.tours[i].description + ' no puede estar vacío.');
                    angular.element(document.querySelector('#date_assigned' + i)).focus();
                    return false;
                }
            }

            for (var i in $scope.hotels) {
                if (_.isNull($scope.hotels[i].date_checkin)) {
                    HelperFactory.show_AlertFactory('La fecha de checkin ' + $scope.tours[i].tradename + ' no puede estar vacío.');
                    angular.element(document.querySelector('#date_checkin' + i)).focus();
                    return false;
                }
                if (_.isNull($scope.hotels[i].date_checkout)) {
                    HelperFactory.show_AlertFactory('La fecha de checkout ' + $scope.tours[i].tradename + ' no puede estar vacío.');
                    angular.element(document.querySelector('#date_checkout' + i)).focus();
                    return false;
                }
                if (Number($scope.hotels[i].rooms) == 0 || _.isNull($scope.hotels[i].rooms)) {
                    HelperFactory.show_AlertFactory('El N° de habitaciones del hotel ' + $scope.hotels[i].tradename + ' no puede estar vacío.');
                    angular.element(document.querySelector('#hotels_rooms' + i)).focus();
                    return false;
                }

                if (Number($scope.hotels[i].nights) == 0 || _.isNull($scope.hotels[i].nights)) {
                    HelperFactory.show_AlertFactory('El N° noches del hotel ' + $scope.hotels[i].tradename + ' no puede estar vacío.');
                    angular.element(document.querySelector('#hotels_nights' + i)).focus();
                    return false;
                }

                if (Number($scope.hotels[i].price) == 0 || _.isNull($scope.hotels[i].price)) {
                    HelperFactory.show_AlertFactory('El precio de habitación del hotel ' + $scope.hotels[i].tradename + ' no puede estar vacío.');
                    angular.element(document.querySelector('#hotels_price' + i)).focus();
                    return false;
                }

            }

            // check totales
            // if (Number($scope.total_tours) == 0 || _.isNull($scope.total_tours)) {
            //     HelperFactory.show_AlertFactory('El total S/. de los tours no puede ser igual a cero o estar vacío');
            //     angular.element(document.querySelector('#total_tours' + i)).focus();
            //     return false;
            // }

            // if (Number($scope.total_book) == 0 || _.isNull($scope.total_book)) {
            //     HelperFactory.show_AlertFactory('El total S/. de la reserva no puede ser igual a cero o estar vacío');
            //     return false;
            // }

            return true;
        }

        function validateCheckin() {
            // if ($scope.tours_edit.length === 0) {
            //     HelperFactory.show_AlertFactory('Para poder realizar el checkin, debe registrar por lo menos un tours al detalle de la reserva, guarde los cambios y vuelva a intentar el checkin');
            //     angular.element(document.querySelector('#search_tour_value')).focus();
            //     return false;
            // }

            return true;
        }

        $scope.checkIn = function () {
            if (validateCheckin()) {
                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de confirmar el check-in de la reserva?",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };
                AlertFactory.confirmInfo(options, function () {
                    RESTService.updated('bookings/checkin', $scope.book.id, $scope.book, function (result) {
                        notifyAlert.success("Check-in realizado con éxito !");
                        $scope.selfUpdate($scope.book.id);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        };

        $scope.selfUpdate = function (model_id) {
            RESTService.get('bookings/edit', model_id, function (response) {
                $state.transitionTo("hotel.bookings.edit", {
                    'id': model_id,
                    entity: response.data
                }, {'reload': "hotel.bookings.edit", 'cache': false});
            });
        };


        $scope.click_total_hotel = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_total_hotels = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_total_flights = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.addClient = function (actionCreate) {
            var obj = {'id': 0};

            if (actionCreate == false) {
                obj = {
                    id: $scope.client,
                    entity: $scope.edit_client.data
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/client/extends.html',
                controller: 'ExtendClientCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.client = data.id;
                    $scope.book.tel_1 = data.cellphone;
                    $scope.book.tel_2 = data.telephone;

                    $timeout(function () {
                        angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                        angular.element(document.querySelector('#search_client_value')).val(data.fullname + ' - ' + data.typeDocument + ':' + data.document);
                    }, 50);
                }
            });
        };

        $scope.addGuest = function (actionCreate) {
            var obj = {'id': 0, 'is_edit':false};

            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: 'lol'
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/client/extends_guest.html',
                controller: 'ExtendGuestCtrl',
                size: 'lg modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    $scope.book_guest.push(result);
                    for (var i = 0; i < $scope.book_guest.length; i++) {
                        var item = $scope.book_guest[i];
                        if (i === 0) {
                            $scope.book_guest[i].is_responsible = true;
                        } else {
                            $scope.book_guest[i].is_responsible = false;
                        }
                    }
                }
            });
        };

        $scope.removeGuest = function ($event, guest, $index) {
            $event.preventDefault();
            var index = $scope.book_guest.indexOf(guest);
            $scope.book_guest.splice(index, 1)
            notifyAlert.info("El huesped " + guest.fullname + ' ha sido removido.');
        };

        $scope.editGuest = function ($event, guest, $index) {
            let val_id = 0;

            if (!_.isUndefined(guest.id)) {
                if (guest.id !== 0) {
                    val_id = guest.id;
                }
            }
            let obj = {'id': val_id, 'is_edit':true, entity:guest};
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/client/extends_guest.html',
                controller: 'ExtendGuestCtrl',
                size: 'lg modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var index = $scope.book_guest.indexOf(result);
                    $scope.book_guest.splice(index, 1);
                    $scope.book_guest.push(result);

                    for (var i = 0; i < $scope.book_guest.length; i++) {
                        var item = $scope.book_guest[i];
                        if (i === 0) {
                            $scope.book_guest[i].is_responsible = true;
                        } else {
                            $scope.book_guest[i].is_responsible = false;
                        }
                    }
                    //
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
                    angular.element(document.querySelector('#search_client_value')).focus();
                }
            });

        }

        $scope.selectedClient = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;
                var unique = ifExistClient(item);
                if (unique) {
                    RESTService.get('client/edit', item.id, function (result) {
                        $scope.editGuest(0, result.data, 0);
                    });  
                }
                else {
                    notifyAlert.warning('El cliente ' + item.fullname + ' ya se encuentra entre la lista de huespedes');
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
                    angular.element(document.querySelector('#search_client_value')).focus();
                }
            }
        };

        function ifExistClient(obj) {
            var cart = $scope.book_guest;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        };

        $scope.checkIn = function () {
            if(validateCheckin()){
                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de confirmar el check-in de la reserva? \n Asegurese de haber guardado los cambios antes",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };
                AlertFactory.confirmInfo(options, function () {
                    RESTService.updated('bookings/checkin', $scope.book.id, $scope.book, function (result) {
                        notifyAlert.success("Check-in realizado con éxito !");
                        $scope.selfUpdate($scope.book.id);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        };

        $scope.checkOut = function () {
            console.log($scope.book);
            if(validateCheckin()){
                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de confirmar el check-out de la reserva? \n Asegurese de haber guardado los cambios antes",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };
                AlertFactory.confirmInfo(options, function () {
                    RESTService.updated('bookings/checkout', $scope.book.id, $scope.book, function (result) {
                        notifyAlert.success("Check-out realizado con éxito !");
                        $scope.selfUpdate($scope.book.id);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        };

        $scope.availableBedroom = function (bedroom_id){
            var object = "bedroom_id=" + bedroom_id + '&start_range=' + $scope.book_bedroom.date_checkin+'&end_range=' + $scope.book_bedroom.date_checkout
                +'&is_edit=' + $scope.is_edit+'&booking_id=' + $scope.book.id;
            RESTService.all('bookings/bedroom/available', object, function (response) {
                $scope.total_overbookings = response.total;
               if(response.total === 0 ){
                   $scope.is_available = true;
                   notifyAlert.success("La habitación " + $scope.bedroomSelected.code_number+" esta disponible para las fechas seleccionadas !");
                }
                else{
                   $scope.is_available = false;
                   $scope.over_bookings = response.results;
                   swal({
                       type: 'warning',
                       title: 'Advertencia !!',
                       html: "Se encontró "+response.total+" reservas para la HABITACIÓN N° ("+$scope.bedroomSelected.code_number+") en las fechas seleccionadas."
                   })
               }
            });
        }

        $scope.listOverbookings = function (){
            let obj = {bedroom:$scope.bedroomSelected, checkin: $scope.book_bedroom.date_checkin, checkout: $scope.book_bedroom.date_checkout, overbookings:$scope.over_bookings};
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/hotel/bookings/overbookings.html',
                controller: 'OverBookingCtrl',
                size: 'lg modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var index = $scope.book_guest.indexOf(result);
                    $scope.book_guest.splice(index, 1);
                    $scope.book_guest.push(result);

                }
            });

        }

        $scope.close = function () {
            $state.transitionTo('hotel.bookings', null, {'reload': true});
        };
        
    }


})();

