(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('PlanningCtrl', PlanningCtrl);

    PlanningCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout'];

    function PlanningCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout) {

        var object = "";
        var start_range = moment();
        var end_range = moment().add(1, 'month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        $scope.events_data = [
            {
                "resourceId": 1,
                "title": "All Day Event",
                "start": "2022-01-01",
                "end": "2022-01-03"
            },];

        init();

        function init() {
            object = "start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
            RESTService.all('bookings/planning', object, function (response) {
                $scope.bedrooms = response.results;
                $scope.events_data = response.events_data;
                for (var i in $scope.events_data) {
                    $scope.events_data[i].resourceId = $scope.events_data[i].resourceid;
                }
                // var events_data = [{resourceId:1,"title":"Content booking","start":"2022-01-11","end":"2022-01-16"},{resourceId:2,"title":"Content booking","start":"2022-01-09","end":"2022-01-15"}];
                var events_data = $scope.events_data;
                generateCalendar($scope.bedrooms, events_data);

            }, function (error) {
                console.log('ERROR');
                return false;
            });
        }

        function generateCalendar(resources_data, events_data) {
            $timeout(function () {
                $(function () {
                    // page is now ready, initialize the calendar...
                    $('#calendar').fullCalendar({
                        defaultView: 'timelineMonth',
                        // defaultDate: new Date(2022, 1),
                        header: {
                            left: 'prev,next',
                            center: 'title',
                            right: 'timelineMonth'
                        },
                        resourceLabelText: 'Habitaciones',
                        // resources: 'https://fullcalendar.io/demo-resources.json',
                        resources: resources_data,
                        // events: 'https://fullcalendar.io/demo-events.json?with-resources'
                        events: events_data,
                        eventRender: function(event, element, view) {
                            // return $('<div>' + event.title + ' es customizado</div>');
                            element.find('.fc-title').empty().append('<span class="yourCSS">tes test</span> ');
                        },
                        monthNames: ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'],
                        monthNamesShort: ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'],
                        lang: 'es',
                    })
                });
            }, 200);
        }

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };
    }
})();
