(function () {

    'use strict';
    angular.module('sys.app.user.new')
        .controller('NewUserCtrl', NewUserCtrl);

    NewUserCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert', '$rootScope', '_', 'HelperFactory', 'ConfigPagination'];

    function NewUserCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert, $rootScope, _, HelperFactory, ConfigPagination) {

        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.user = $stateParams.entity;
                if ($scope.user.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.user.name = $scope.entity.name;
                    $scope.user.surname = $scope.entity.surname;
                    $scope.user.document = $scope.entity.document;
                    $scope.user.telephone = $scope.entity.telephone;
                    $scope.user.email = $scope.entity.email;
                    $scope.user.address = $scope.entity.address;
                }
                else
                {
                    $scope.txt_title = 'Registrar'
                    $scope.user = {
                        'name': null,
                        'surname': null,
                        'document': null,
                        'telephone': null,
                        'email': null,
                        'password': null,
                        'address':null
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('management.users', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {
            angular.element(document.querySelector('#user_document')).focus();

            RESTService.all('user/list_profile', null, function (response) {
                $scope.profiles = response.results;
                $scope.profileSelected = response.results[0];
                profileSelected($scope.user.profile_id);
            });
        }

        function profileSelected(id) {
            if(!_.isUndefined(id)){
                $scope.profileSelected = ConfigPagination.searchById(id,$scope.profiles);
            }
        }

        $scope.save = function () {
            if (validate()) {

                $scope.user['profile_id'] = $scope.profileSelected.id;
                RESTService.save('user/save', $scope.user, function (result) {
                    notifyAlert.success("Registro realizado con éxito!!");
                    $state.transitionTo('management.users', null, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };


        $scope.edit = function () {
            if (validate()) {

                $scope.user['profile_id'] = $scope.profileSelected.id;

                RESTService.updated('user/update', $scope.user.id, $scope.user, function (result) {
                    notifyAlert.success("Registro actualizado con éxito!!");
                    $state.transitionTo('management.users', null, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        }

        function validate() {

            if (_.isNull($scope.user.document) || _.isEmpty($scope.user.document)) {
                HelperFactory.show_AlertFactory('Debe ingresar el N° documento del usuario');
                angular.element(document.querySelector('#user_document')).focus();
                return false;
            }

            if (_.isNull($scope.user.name) || _.isEmpty($scope.user.name)) {
                HelperFactory.show_AlertFactory('Debe ingresar el nombre del usuario');
                angular.element(document.querySelector('#user_name')).focus();
                return false;
            }

            if (_.isNull($scope.user.email) || _.isEmpty($scope.user.email)) {
                HelperFactory.show_AlertFactory('Debe ingresar el correo del usuario');
                angular.element(document.querySelector('#user_email')).focus();
                return false;
            }

            // if (_.isNull($scope.user.password) || _.isEmpty($scope.user.password)) {
            //     HelperFactory.show_AlertFactory('Debe ingresar la contraseña del usuario');
            //     angular.element(document.querySelector('#user_password')).focus();
            //     return false;
            // }

            if (_.isNull($scope.profileSelected) || _.isEmpty($scope.profileSelected)) {
                HelperFactory.show_AlertFactory('Debe ingresar el perfil del usuario');
                angular.element(document.querySelector('#profileSelected')).focus();
                return false;
            }


            return true;
        };


        $scope.close = function () {
            $state.transitionTo('management.users', null, {'reload': true});
        };


    }

})();

