(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('AmortizeChargeCtrl', AmortizeChargeCtrl);

    AmortizeChargeCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout', 'EXPORT'];

    function AmortizeChargeCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, EXPORT) {

        $scope.schedule = PARAM.schedule;
        $scope.sale = PARAM.sale;

        init();

        function init() {
            RESTService.all('config/paymentmethod', null, function (response) {
                $scope.paymentmethods = response.results;
                $scope.paymentSelected = response.results[0];
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });

            $scope.paid = {
                'gloss':null,
                'amount':null
            };

            $timeout(function () {
                angular.element(document.querySelector('#amount')).focus();
            }, 100);

        };

        $scope.paidAmortization = function () {
            if(validate()){

                $scope.paid['currency_id'] = $scope.currencySelected.id;
                $scope.paid['paymentmethod_id'] = $scope.paymentSelected.id;
                $scope.paid['client_id'] = $scope.sale.client_id;
                $scope.paid['sale_id'] = $scope.sale.id;

                var data = {};
                data.paid = $scope.paid;
                data.schedule = $scope.schedule;

                RESTService.save('money/charge/amortization', data, function (result) {
                    notifyAlert.success("Registro realizado con éxito!!");
                    $uibModalInstance.close(result);

                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };

        $scope.click_input_amount = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        function validate() {
            if (_.isNull($scope.paid.amount)) {
                HelperFactory.show_AlertFactory('Debe ingresar el monto a pagar.');
                angular.element(document.querySelector('#amount')).focus();
                return false;
            }

            if($scope.paid.amount == 0){
                HelperFactory.show_AlertFactory('El monto a pagar no puede ser igual a cero.');
                angular.element(document.querySelector('#amount')).focus();
                return false;
            }

            if (_.isNull($scope.paid.gloss)) {
                HelperFactory.show_AlertFactory('Debe especificar la descripción.');
                angular.element(document.querySelector('#amount')).focus();
                return false;
            }

            return true;
        }

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };
    }

})();
