(function () {
    'use strict';
    angular.module('sys.app.charge')
        .controller('ChargeCtrl', ChargeCtrl);

    ChargeCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', '$uibModal'];

    function ChargeCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page='+ $scope.currentPage;
            RESTService.all('money/charge/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

                // console.log($scope.allData);

            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('money.charges', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var source = {'id': 0};
            $state.transitionTo('money.expenses.new', {entity: source}, {
                'reload': 'money.expenses.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('expenses/edit', source.id, function (response) {
                $state.transitionTo("money.expenses.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "money.expenses.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        };

        $scope.detail = function (source) {
            delete $scope.allData;
            RESTService.get('money/charge/detail', source.id, function (response) {
                $state.transitionTo("money.charges.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "money.charges.detail", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.associateSale = function (sale_id) {
            RESTService.get('sales/detail', sale_id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/sales/sale/modaldetail.html',
                    controller: 'ModalDetailSaleCtrl',
                    size: 'modal-dialog modal-lg',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('expenses/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('money.expenses', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };


    }
})();



