(function () {

    'use strict';
    angular.module('sys.app.charge.detail')
        .controller('DetailChargeCtrl', DetailChargeCtrl);

    DetailChargeCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert','_', 'HelperFactory', '$timeout', 'ORDER', 'SEARCH', 'AlertFactory', 'ConfigPagination', '$uibModal', 'VOUCHER'];

    function DetailChargeCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert,_, HelperFactory, $timeout, ORDER, SEARCH, AlertFactory, ConfigPagination, $uibModal, VOUCHER) {

        try {

            $scope.check_sale = $stateParams.entity.sale;
            if (!_.isNull($scope.check_sale.id)) {
                $scope.entity = $stateParams.entity.sale;
                $scope.sale = $stateParams.entity.sale;

                $scope.voucher_ruc = VOUCHER['FACTURA'];
                $scope.voucher_boleta = VOUCHER['BOLETA'];
                $scope.voucher_income = VOUCHER['RECIBO_INGRESO'];
                $scope.voucher_expense = VOUCHER['RECIBO_EGRESO'];
                $scope.voucher_ordernote = VOUCHER['NOTA_PEDIDO'];

                if ($scope.sale.id != 0) {
                    $scope.schedule = $stateParams.entity.schedule;
                    $scope.schedule_detail = $stateParams.entity.schedule_detail;
                    $scope.movements = $stateParams.entity.movements;
                }
            }
        }
        catch (e) {
            $state.transitionTo('money.charges', null, {'reload': true});
            console.log(e);
            return false;
        }

        $scope.amortize = function () {
            var obj = {
                'sale':$scope.sale,
                'schedule':$scope.schedule
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/money/charge/amortize.html',
                controller: 'AmortizeChargeCtrl',
                size: 'modal-dialog modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {

                swal({
                    title: "EN HORA BUENA!",
                    html: '<b>Pago amortizado correctamente!</b>, ¿Desea imprimir el recibo?</br></br>',
                    type: "success",
                    showCancelButton: true,
                    confirmButtonColor: "#30419b",
                    cancelButtonClass: 'btn btn-secondary ml-2',
                    confirmButtonText: 'Imprimir <i class="fas fa-print m-r-5"></i>',
                    cancelButtonText: "Cancelar",
                }).then(function (isConfirm) {
                    if (isConfirm.value == true) {
                        window.open('/print/income/document/' + result.data.id);
                    }
                });
                RESTService.get('money/charge/detail', $scope.sale.id, function (response) {
                    $state.transitionTo("money.charges.detail", {
                        'id': $scope.sale.id,
                        entity: response.data
                    }, {'reload': "money.charges.detail", 'cache': false});
                });
            });
        };


        $scope.associateSale = function (sale_id) {
            RESTService.get('sales/detail', sale_id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/sales/sale/modaldetail.html',
                    controller: 'ModalDetailSaleCtrl',
                    size: 'modal-dialog modal-lg',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        // $scope.delete = function (item) {
        //
        // };

        $scope.close = function () {
            $state.transitionTo('money.charges', null, {'reload': true});
        };

    }

})();

