(function () {
    'use strict';
    angular.module('sys.app.historybox')
        .controller('HistoryBoxCtrl', HistoryBoxCtrl);

    HistoryBoxCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH'];

    function HistoryBoxCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page='+ $scope.currentPage;

            RESTService.all('money/historybox/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;


            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('money.historybox', {entity: null}, {'reload': true});
        };


        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('expenses/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('money.expenses', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };


    }
})();



