(function () {
    'use strict';
    angular.module('sys.app.income')
        .controller('IncomeCtrl', IncomeCtrl);

    IncomeCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH'];

    function IncomeCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        $scope.date_range = moment().format('YYYY-MM-DD');

        init();
        sync();

        function init() {
            object = "search=" + $scope.text + '&page='+ $scope.currentPage+
                "&date_range=" + $scope.date_range;

            RESTService.all('money/income/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        function sync() {
            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'YYYY-MM-DD'
                        },
                        singleDatePicker: true,
                        showDropdowns: true,
                    }, function (start, end, label) {
                        $scope.date_range = start.format('YYYY-MM-DD');
                        init();
                    }
                );
            }, 100);
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('money.incomes', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var source = {'id': 0};
            $state.transitionTo('money.incomes.new', {entity: source}, {
                'reload': 'money.incomes.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('money/income/edit', source.id, function (response) {
                $state.transitionTo("money.incomes.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "money.incomes.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        // $scope.detail = function (source) {
        //
        //     delete $scope.allData;
        //     RESTService.get('incomes/detail', source.id, function (response) {
        //         $state.transitionTo("money.incomes.detail", {
        //             'id': source.id,
        //             entity: response.data
        //         }, {'reload': "money.incomes.detail", 'cache': false});
        //     }, function (error) {
        //         console.log('ERROR');
        //         return false;
        //     });
        // };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.nro_voucher+" ' será anulado",
                cancel: "Cancelar",
                confirm: "Anular"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('money/income/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha anulado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('money.incomes', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };


    }
})();



