(function () {

    'use strict';
    angular.module('sys.app.income.new')
        .controller('NewIncomeCtrl', NewIncomeCtrl);

    NewIncomeCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory', '$timeout', '$uibModal', 'ConfigPagination', 'PAYMENT_METHOD', 'USER'];

    function NewIncomeCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory, $timeout, $uibModal, ConfigPagination, PAYMENT_METHOD, USER) {

        $scope.userposition = USER.POSITION;
        $scope.positionSelected =  USER.POSITION[0];

        $scope.is_client = USER.POSITION[0].id;
        $scope.is_provider = USER.POSITION[1].id;
        $scope.is_employee = USER.POSITION[2].id;

        $scope.paymethod_deposit = PAYMENT_METHOD['deposit'];

        $scope.provider = null;
        $scope.client = null;
        $scope.employee = null;

        $scope.bankaccounts = [];

        $scope.is_edit = false;

        $scope.change_amount = true;

        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.income = $stateParams.entity;
                if ($scope.income.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';

                    $scope.is_edit = true;
                    $scope.change_amount = false;

                    if($scope.income.client_id != null){
                        $scope.positionSelected = USER.POSITION[0];
                        clientSelected($scope.income);
                    };

                    if($scope.income.provider_id != null){
                        $scope.positionSelected = USER.POSITION[1];
                        providerSelected($scope.income);
                    };

                    if($scope.income.employee_id != null){
                        $scope.positionSelected = USER.POSITION[2];
                        employeeSelected($scope.income);
                    };
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';

                    $scope.income = {
                        'gloss': null,
                        'amount': null,
                        'reference_operation': null,
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('money.incomes', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {
            RESTService.all('branch/listboxes', null, function (response) {
                $scope.branchboxes = response.results;
                checkBoxSelected();
            });

            RESTService.all('config/paymentmethod', null, function (response) {
                $scope.paymentmethods = response.results;
                $scope.paymentSelected = response.results[0];

                paymentSelected($scope.income.paymentmethod_id);
            });

            RESTService.all('money/concept/incomes', null, function (response) {
                $scope.concepts = response.results;
                var last = $scope.concepts.length;
                $scope.concepts[last] = {id: null, description:'Seleccione concepto', value:null};
                $scope.conceptSelected = response.results[last];

                conceptSelected($scope.income.concept_id);
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });

            if($scope.is_edit){
                if($scope.income.paymentmethod_id == $scope.paymethod_deposit.id){
                    RESTService.all('accountbanks/search/all', null, function (response) {
                        $scope.bankaccounts = response.results;
                        $scope.bankaccounts_exists = false;
                        if($scope.bankaccounts.length>0){
                            $scope.bankaccounts_exists = true;
                            $scope.bankAccountSelected = response.results[0];

                            accountBankSelected($scope.income.accountbank_id);
                        }
                    });
                }
            }

            $timeout(function () {

                $('[data-toggle="tooltip"]').tooltip();

                angular.element(document.querySelector('#income_gloss')).focus();
            }, 100);
        };

        function clientSelected(data) {
            $scope.client = data.client_id;
            $timeout(function () {
                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                $timeout(function () {
                    angular.element(document.querySelector('#search_client_value')).val(data.receptor_fullname);
                }, 100);
            }, 100);
        };

        function providerSelected(data) {
            $scope.provider = data.provider_id;
            $timeout(function () {
                angular.element(document.querySelector('#search_provider_value')).attr('disabled', 'disabled');
                $timeout(function () {
                    angular.element(document.querySelector('#search_provider_value')).val(data.receptor_fullname);
                }, 100);
            }, 100);
        };

        function employeeSelected(data) {
            $scope.employee = data.employed_id;
            $timeout(function () {
                angular.element(document.querySelector('#search_employee_value')).attr('disabled', 'disabled');
                $timeout(function () {
                    angular.element(document.querySelector('#search_employee_value')).val(data.receptor_fullname);
                }, 100);
            }, 100);
        };

        function conceptSelected(id) {
            if(!_.isUndefined(id)){
                $scope.conceptSelected = ConfigPagination.searchById(id,$scope.concepts);
            }
        };

        function paymentSelected(id) {
            if(!_.isUndefined(id)){
                $scope.paymentSelected = ConfigPagination.searchById(id,$scope.paymentmethods);
            }
        };

        function accountBankSelected(id) {
            if(!_.isUndefined(id)){
                if(id != null){
                    $scope.bankAccountSelected = ConfigPagination.searchById(id,$scope.bankaccounts);
                }
            }
        };

        function checkBoxSelected() {
            RESTService.all('branch/checkboxselected', null, function (response) {
                $scope.checkbox = response.results;
                $scope.branchbox_id = response.branchbox_id;
                if($scope.checkbox){
                    boxSelected($scope.branchbox_id);
                }
                else{
                    HelperFactory.show_AlertFactory('Por favor seleccione y aperture una caja para poder realizar movimientos de dinero.');
                }
            });
        }

        function boxSelected(id) {
            if(!_.isNull(id)){
                $scope.boxSelected = ConfigPagination.searchById(id,$scope.branchboxes);
            }
        }

        $scope.click_input_amount = function (msg, $event) {
            var el = event.target;
            el.select();
        };


        $scope.activeChangeAmount = function (item) {
            $scope.change_amount = item;
            if($scope.change_amount == true){
                $timeout(function () {
                    angular.element(document.querySelector('#income_amount')).focus();
                }, 50);
            }
        };

        $scope.changePayment = function (item) {
            $scope.paymentSelected = item;
            if(item.id == $scope.paymethod_deposit.id){
                RESTService.all('accountbanks/search/all', null, function (response) {
                    $scope.bankaccounts = response.results;
                    $scope.bankaccounts_exists = false;
                    if($scope.bankaccounts.length>0){
                        $scope.bankaccounts_exists = true;
                        $scope.bankAccountSelected = response.results[0];
                    }
                });
            }
        };

        $scope.changeBankAccount = function (item) {
            $scope.bankAccountSelected = item;
        };

        $scope.selectedClient = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.client = data.id;
                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
            }
        };

        $scope.selectedProvider = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.provider = data.id;
                angular.element(document.querySelector('#search_provider_value')).attr('disabled', 'disabled');
            }
        };

        $scope.selectedEmployee = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.employee = data.id;
                angular.element(document.querySelector('#search_employee_value')).attr('disabled', 'disabled');
            }
        };

        $scope.removeClient = function () {
            angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_client_value')).val('');
            $scope.client = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
        };

        $scope.removeProvider = function () {
            angular.element(document.querySelector('#search_provider_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_provider_value')).val('');
            $scope.provider = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_provider');
        };

        $scope.removeEmployee = function () {
            angular.element(document.querySelector('#search_employee_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_employee_value')).val('');
            $scope.employee = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_employee');
        };

        $scope.addProvider = function (actionCreate) {
            var obj = {'id': 0};

            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: 'lol'
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/purchase/providers/extends.html',
                controller: 'ExtendProviderCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.provider = data.id;
                    $timeout(function () {
                        angular.element(document.querySelector('#search_provider_value')).val(data.fullname);
                        angular.element(document.querySelector('#search_provider_value')).attr('disabled', 'disabled');
                    }, 50);
                }
            });
        };

        $scope.addClient = function (actionCreate) {
            var obj = {'id': 0};

            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: 'lol'
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/client/extends.html',
                controller: 'ExtendClientCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.client = data.id;

                    $timeout(function () {
                        angular.element(document.querySelector('#search_client_value')).val(data.fullname);
                        angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    }, 50);
                }
            });
        };


        $scope.save = function () {
            if (validate()) {
                var data = {};
                $scope.income['currency_id'] = $scope.currencySelected.id;
                $scope.income['concept_id'] = $scope.conceptSelected.id;
                $scope.income['paymentmethod_id'] = $scope.paymentSelected.id;
                $scope.income['provider_id'] = $scope.provider;
                $scope.income['client_id'] = $scope.client;
                $scope.income['employee_id'] = $scope.employee;

                $scope.income['change_amount'] = $scope.change_amount;

                var accountbank_id = null;
                if($scope.bankaccounts.length > 0){
                    if($scope.paymentSelected.id == $scope.paymethod_deposit.id){
                        accountbank_id = $scope.bankAccountSelected.id;
                    }
                };

                $scope.income['accountbank_id'] = accountbank_id ;

                data.income = $scope.income;

                if ($scope.action == 'create') {
                    RESTService.save('money/income/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('money.incomes', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if ($scope.action == 'edit') {
                    RESTService.updated('money/income/update', $scope.income.id, data, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('money.incomes', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {

            if (_.isNull($scope.income.gloss)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción del ingreso.');
                angular.element(document.querySelector('#income_gloss')).focus();
                return false;
            }

            if (_.isNull($scope.conceptSelected.id)) {
                HelperFactory.show_AlertFactory('Debe seleccionar un concepto');
                angular.element(document.querySelector('#conceptSelected')).focus();
                return false;
            }
            if (_.isNull($scope.income.amount)) {
                HelperFactory.show_AlertFactory('Debe ingresar el monto del ingreso');
                angular.element(document.querySelector('#income_amount')).focus();
                return false;
            }

            return true;
        };

        $scope.addAccountBank = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/finance/accountbank/extends.html',
                controller: 'ExtendAccountBankCtrl',
                size: 'md',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.bankaccounts.push(data);
                    $scope.bankAccountSelected = data;
                    $scope.bankaccounts_exists = true;
                }
            });
        };

        $scope.close = function () {
            $state.transitionTo('money.incomes', null, {'reload': true});
        };
    }

})();

