
(function () {
    'use strict';

    angular.module('sys.app.money').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];


    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider

            .state('money.opening', {
                url: '/apertura',
                templateUrl: '../../templates/money/opening.html',
                controller: 'MoneyOpeningCtrl',
                params: {
                    entity: null
                },
                title: "Caja",
                module:"opening",
            })

            .state('money.incomes', {
                url: '/ingresos',
                templateUrl: '../../templates/money/income.html',
                controller: 'IncomeCtrl',
                params: {
                    entity: null
                },
                title: "Ingresos caja",
                module:"incomes",
            })

            .state('money.expenses', {
                url: '/egresos',
                templateUrl: '../../templates/money/expense.html',
                controller: 'ExpenseCtrl',
                params: {
                    entity: null
                },
                title: "Egresos caja",
                module:"expenses",
            })

            .state('money.historybox', {
                url: '/historial/cajas',
                templateUrl: '../../templates/money/historybox.html',
                controller: 'HistoryBoxCtrl',
                params: {
                    entity: null
                },
                title: "Historial cajas",
                module:"historybox",
            })

            .state('money.charges', {
                url: '/cobros',
                templateUrl: '../../templates/money/charge.html',
                controller: 'ChargeCtrl',
                params: {
                    entity: null
                },
                title: "Cobros pendientes",
                module:"charges",
            })

            .state('money.moneymovements', {
                url: '/movimientos/caja',
                templateUrl: '../../templates/money/moneymovements.html',
                controller: 'MoneyMovementsCtrl',
                params: {
                    entity: null
                },
                title: "Movimientos caja",
                module:"moneymovements",
            })

            .state('money.pendingpayments', {
                url: '/pagos',
                templateUrl: '../../templates/money/pendingpayments.html',
                controller: 'PendingPaymentsCtrl',
                params: {
                    entity: null
                },
                title: "Cobros pendientes",
                module:"pendingpayments",
            })
        ;

        $urlRouterProvider.otherwise('/apertura');
    }

})();


