(function () {
    'use strict';
    angular.module('sys.app.moneymovements')
        .controller('MoneyMovementsCtrl', MoneyMovementsCtrl);

    MoneyMovementsCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', 'VOUCHER', '$uibModal', '$stateParams'];

    function MoneyMovementsCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, VOUCHER, $uibModal, $stateParams) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        $scope.date_range = moment().format('YYYY-MM-DD');

        $scope.voucher_ruc = VOUCHER['FACTURA'];
        $scope.voucher_boleta = VOUCHER['BOLETA'];
        $scope.voucher_income = VOUCHER['RECIBO_INGRESO'];
        $scope.voucher_expense = VOUCHER['RECIBO_EGRESO'];
        $scope.voucher_ordernote = VOUCHER['NOTA_PEDIDO'];

        if(!_.isNull($stateParams.entity)){
            $scope.text = $stateParams.entity;
            $timeout(function () {
                angular.element(document.querySelector('#searchInput')).val($scope.text);
            }, 100);
        };

        init();
        sync();

        function init() {
            object = "search=" + $scope.text + '&page='+ $scope.currentPage+
                "&date_range=" + $scope.date_range;

            RESTService.all('money/movements/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;


            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        function sync() {
            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'YYYY-MM-DD'
                        },
                        singleDatePicker: true,
                        showDropdowns: true,
                    }, function (start, end, label) {
                        $scope.date_range = start.format('YYYY-MM-DD');
                        init();
                    }
                );
            }, 100);
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('money.historybox', {entity: null}, {'reload': true});
        };


        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('expenses/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('money.expenses', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.associateSale = function (sale_id) {
            RESTService.get('sales/detail', sale_id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/sales/sale/modaldetail.html',
                    controller: 'ModalDetailSaleCtrl',
                    size: 'modal-dialog modal-lg',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        $scope.printVoucher = function (item) {
            RESTService.get('billing/print/voucher', item.id, function (response) {
                window.open('/print/billing/document/'+ response.sale_id)
            });
        };

        $scope.cancelledVoucher = function (item) {
            var obj = {'voucher': item};
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/billing/voucher/cancelledvoucher.html',
                controller: 'ExtendCancelledVoucherCtrl',
                size: 'modal-dialog modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if(result.payments.length == 0){
                    swal({
                        title: "Importante!",
                        html: '<b>Se ha anulado el comprobante '+item.nro_voucher+' asociado a la venta '+item.sale_code+'</b>., <br> ¿Desea rehacer la venta?',
                        type: "success",
                        showCancelButton: true,
                        confirmButtonColor: "#30419b",
                        cancelButtonClass: 'btn btn-secondary ml-2',
                        confirmButtonText: 'Rehacer venta <i class="fas fa-cart-plus m-r-5"></i>',
                        cancelButtonText: "Cancelar",
                    }).then(function (isConfirm) {
                        if (isConfirm.value == true) {
                            RESTService.get('sales/remake', item.sale_id, function (response) {
                                $state.transitionTo("sales.sale.new", {
                                    id: 0,
                                    entity: response.data
                                }, {'reload': "sales.sale.new", 'cache': false});
                            }, function (error) {
                                console.log('ERROR');
                                return false;
                            });
                        }
                        else {
                            var obj = {"text": $scope.text};
                            $state.transitionTo('money.moneymovements', {entity: obj}, {'reload': true});
                        }

                    });
                }
                else{
                    var obj = {"text": $scope.text};
                    $state.transitionTo('money.moneymovements', {entity: obj}, {'reload': true});
                }

            });
        };

        $scope.deleteIncome = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El "+item.typevoucher+" "+item.nro_voucher+" será anulado",
                cancel: "Cancelar",
                confirm: "Anular"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('money/income/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha anulado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('money.moneymovements', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.deleteExpense = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El "+item.typevoucher+" "+item.nro_voucher+" será anulado",
                cancel: "Cancelar",
                confirm: "Anular"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('money/expense/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha anulado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('money.moneymovements', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };

    }
})();



