(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendBranchBoxesCtrl', ExtendBranchBoxesCtrl);

    ExtendBranchBoxesCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout'];

    function ExtendBranchBoxesCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout) {


        $timeout(function () {
            $scope.boxes = PARAM.boxes;
            $scope.boxSelected = $scope.boxes[0];
        }, 100);



        $scope.changeBox = function (item) {
            $scope.boxSelected = item;
        }


        $scope.save = function () {
            if (validate()) {

                var data = {};
                data.boxselected = $scope.boxSelected.id;

                RESTService.save('branch/selectbox', data, function (result) {
                    notifyAlert.success("Se ha seleccionado la "+ $scope.boxSelected.description);
                    $uibModalInstance.close(result);
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };

        function validate() {
            if (_.isUndefined($scope.boxSelected)) {
                HelperFactory.show_AlertFactory('Debe seleccionar una caja para aperturar.');
                angular.element(document.querySelector('#boxSelected')).focus();
                return false;
            }

            return true;
        }

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
            $state.transitionTo('dashboard', null, {'reload': true});
        };
    }

})();
