(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendOpenBoxCtrl', ExtendOpenBoxCtrl);

    ExtendOpenBoxCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout'];

    function ExtendOpenBoxCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout) {

        $scope.amount_opening = null;

        $timeout(function () {
            angular.element(document.querySelector('#amount_opening')).focus();
        }, 100);

        $scope.save = function () {
            if(validate()){
                var data = {};
                data.amount_opening = $scope.amount_opening;

                RESTService.save('money/openbox', data, function (result) {
                    notifyAlert.success("Caja aperturada con éxito!!");
                    $timeout(function () {
                        $uibModalInstance.close(result);
                    }, 20);
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };

        function validate() {
            if (_.isNull($scope.amount_opening)) {
                HelperFactory.show_AlertFactory('Debe ingresar el monto de apertura.');
                angular.element(document.querySelector('#amount_opening')).focus();
                return false;
            }

            return true;
        }

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };
    }

})();
