(function () {
    'use strict';
    angular.module('sys.app.opening')
        .controller('MoneyOpeningCtrl', MoneyOpeningCtrl);

    MoneyOpeningCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal'];

    function MoneyOpeningCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal) {

        init();

        function init() {

            RESTService.all('branch/listboxes', null, function (response) {
                $scope.branchboxes = response.results;
            }, function (error) {
                console.log('ERROR');
                return false;
            });

            RESTService.all('branch/checkboxselected', null, function (response) {
                $scope.checkbox = response.results;
                $scope.branchbox_id = response.branchbox_id;
                getListBoxes($scope.checkbox);
            }, function (error) {
                console.log('ERROR');
                return false;
            });


        }

        function getListBoxes(checkbox) {
            if (checkbox) {
                RESTService.all('money/information/opening', null, function (response) {
                    $scope.date = response.date;
                    $scope.user = response.user;
                    $scope.moneybox = response.moneybox;
                    $scope.summary_paymethods = response.summary_paymethods;

                    $timeout(function () {
                        boxSelected($scope.branchbox_id);
                    }, 50)

                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            } else {
                // get branch boxes
                $timeout(function () {
                    openBranchBoxes($scope.branchboxes);
                }, 100)

                // RESTService.all('branch/listboxes', null, function (response) {
                //     $scope.branchboxes = response.results;
                //     openBranchBoxes($scope.branchboxes);
                // }, function (error) {
                //     console.log('ERROR');
                //     return false;
                // });
            }
        }

        function boxSelected(id) {
            if(!_.isNull(id)){
                $scope.boxSelected = ConfigPagination.searchById(id,$scope.branchboxes);
            }
        }

        $scope.changeBox = function (item) {
            var data = {};
            data.boxselected = item.id;

            RESTService.save('branch/selectbox', data, function (result) {
                notifyAlert.success("Se ha seleccionado la "+ $scope.boxSelected.description)
                // init();
                location.reload();

            }, function (error) {
                console.log('ERROR');
                return false;
            });
        }
        
        function openBranchBoxes(boxes) {
            var obj = {'boxes': boxes};
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/money/branchboxes.html',
                controller: 'ExtendBranchBoxesCtrl',
                size: 'sm modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                init();
            });
        }

        $scope.openBox = function () {
            var obj = {'box': 0};
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/money/openbox.html',
                controller: 'ExtendOpenBoxCtrl',
                size: 'sm',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                location.reload();
                // init();
            });
        };


        $scope.closeBox = function () {

            var data = {};
            data.moneybox = $scope.moneybox;

            var options = {
                title: "¿Estás seguro(a)?",
                message: "Está por cerrar la caja con S/ " + $scope.moneybox.balance + ", antes le recomendamos realizar su arqueo !! ",
                cancel: "Minimizar",
                confirm: "Confirmar cierre"
            };
            AlertFactory.confirm(options, function () {
                RESTService.save('money/closebox', data, function (result) {
                    notifyAlert.success("Caja cerrada con éxito!!");
                    $timeout(function () {
                        location.reload();
                    }, 20);
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            });
        };
    }
})();



